/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DetainRestrictionEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;

public class DetainTargetEffect
extends OneShotEffect {
    public DetainTargetEffect() {
        super(Outcome.LoseAbility);
    }

    protected DetainTargetEffect(DetainTargetEffect effect) {
        super(effect);
    }

    @Override
    public DetainTargetEffect copy() {
        return new DetainTargetEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        if (!game.isSimulation()) {
            for (UUID target : this.getTargetPointer().getTargets(game, source)) {
                Permanent permanent = game.getPermanent(target);
                if (permanent == null) continue;
                game.informPlayers("Detained permanent: " + permanent.getName());
            }
        }
        game.addEffect(new DetainRestrictionEffect(), source);
        return true;
    }

    @Override
    public String getText(Mode mode) {
        if (this.staticText != null && !this.staticText.isEmpty()) {
            return this.staticText;
        }
        String description = this.getTargetPointer().describeTargets(mode.getTargets(), "that creature");
        boolean plural = this.getTargetPointer().isPlural(mode.getTargets());
        String reminder = ". <i>(Until your next turn, " + (plural ? "those " : "that ") + (description.contains("creature") ? "creature" : "permanent") + (plural ? "s" : "") + " can't attack or block and " + (plural ? "their" : "its") + " activated abilities can't be activated.)</i>";
        return "detain " + description + reminder;
    }
}

