/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.predicate.mageobject.AnotherPredicate;
import mage.game.Game;
import mage.game.events.EntersTheBattlefieldEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.common.TargetSacrifice;
import mage.util.CardUtil;

public class DevourEffect
extends ReplacementEffectImpl {
    private final int devourFactor;
    private final FilterPermanent filterDevoured;

    public DevourEffect(int devourFactor, FilterPermanent filterDevoured) {
        super(Duration.EndOfGame, Outcome.Detriment);
        this.devourFactor = devourFactor;
        this.filterDevoured = filterDevoured;
    }

    private DevourEffect(DevourEffect effect) {
        super(effect);
        this.devourFactor = effect.devourFactor;
        this.filterDevoured = effect.filterDevoured;
    }

    @Override
    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD;
    }

    @Override
    public boolean applies(GameEvent event, Ability source, Game game) {
        if (event.getTargetId().equals(source.getSourceId())) {
            Permanent sourcePermanent = ((EntersTheBattlefieldEvent)event).getTarget();
            game.getState().setValue(sourcePermanent.getId().toString() + "devoured", null);
            return true;
        }
        return false;
    }

    @Override
    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Permanent creature = ((EntersTheBattlefieldEvent)event).getTarget();
        Player controller = game.getPlayer(source.getControllerId());
        if (creature == null || controller == null) {
            return false;
        }
        FilterPermanent filter = this.filterDevoured.copy();
        filter.setMessage(this.filterDevoured.getMessage() + "s (to devour)");
        filter.add(AnotherPredicate.instance);
        TargetSacrifice target = new TargetSacrifice(1, Integer.MAX_VALUE, filter);
        if (!target.canChoose(source.getControllerId(), source, game)) {
            return false;
        }
        if (!controller.chooseUse(Outcome.Detriment, "Devour " + this.filterDevoured.getMessage() + "s?", source, game)) {
            return false;
        }
        controller.chooseTarget(Outcome.Detriment, target, source, game);
        if (target.getTargets().isEmpty()) {
            return false;
        }
        ArrayList<Permanent> creaturesDevoured = new ArrayList<Permanent>();
        int devouredCreatures = 0;
        for (UUID targetId : target.getTargets()) {
            Permanent targetCreature = game.getPermanent(targetId);
            if (targetCreature == null || !targetCreature.sacrifice(source, game)) continue;
            creaturesDevoured.add(targetCreature);
            ++devouredCreatures;
        }
        game.informPlayers(creature.getLogName() + " devours " + devouredCreatures + " " + this.filterDevoured.getMessage() + (devouredCreatures > 1 ? "s" : ""));
        game.processAction();
        int amountCounters = this.devourFactor == Integer.MAX_VALUE ? devouredCreatures * devouredCreatures : devouredCreatures * this.devourFactor;
        creature.addCounters(CounterType.P1P1.createInstance(amountCounters), source.getControllerId(), source, game);
        game.getState().setValue(creature.getId().toString() + "devoured", creaturesDevoured);
        return false;
    }

    @Override
    public String getText(Mode mode) {
        if (this.staticText != null && !this.staticText.isEmpty()) {
            return this.staticText;
        }
        String text = "Devour ";
        String filterMessage = this.filterDevoured.getMessage();
        if (!filterMessage.equals("creature")) {
            text = text + filterMessage + " ";
        }
        text = this.devourFactor == Integer.MAX_VALUE ? text + "X, where X is the number of " + filterMessage + "s devoured this way" : text + this.devourFactor;
        text = text + " <i>(As this creature enters, you may sacrifice any number of " + filterMessage + "s. This creature enters with ";
        if (this.devourFactor == Integer.MAX_VALUE) {
            text = text + "X +1/+1 counters on it for each of those creatures";
        } else {
            if (this.devourFactor == 2) {
                text = text + "twice ";
            } else if (this.devourFactor > 2) {
                text = text + CardUtil.numberToText(this.devourFactor) + " times ";
            }
            text = text + "that many +1/+1 counters on it";
        }
        text = text + ".)</i>";
        return text;
    }

    public List<Permanent> getDevouredCreatures(Game game, UUID permanentId) {
        Object object = game.getState().getValue(permanentId.toString() + "devoured");
        if (object != null) {
            return (List)object;
        }
        return Collections.emptyList();
    }

    public int getDevouredCreaturesAmount(Game game, UUID permanentId) {
        Object object = game.getState().getValue(permanentId.toString() + "devoured");
        if (object != null) {
            return ((List)object).size();
        }
        return 0;
    }

    @Override
    public DevourEffect copy() {
        return new DevourEffect(this);
    }
}

