/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.costs.Cost;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.Effects;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;
import mage.util.ManaUtil;

public class DoUnlessAnyPlayerPaysEffect
extends OneShotEffect {
    protected Effects executingEffects = new Effects(new Effect[0]);
    protected Cost cost;
    private String chooseUseText;
    protected DynamicValue genericMana;

    public DoUnlessAnyPlayerPaysEffect(Effect effect, DynamicValue genericMana) {
        super(Outcome.Detriment);
        this.genericMana = genericMana;
        this.executingEffects.add(effect);
    }

    public DoUnlessAnyPlayerPaysEffect(Effect effect, Cost cost) {
        this(effect, cost, null);
    }

    public DoUnlessAnyPlayerPaysEffect(Effect effect, Cost cost, String chooseUseText) {
        super(Outcome.Neutral);
        this.executingEffects.add(effect);
        this.cost = cost;
        this.chooseUseText = chooseUseText;
    }

    protected DoUnlessAnyPlayerPaysEffect(DoUnlessAnyPlayerPaysEffect effect) {
        super(effect);
        if (effect.cost != null) {
            this.cost = effect.cost.copy();
        }
        if (effect.genericMana != null) {
            this.genericMana = effect.genericMana.copy();
        }
        this.executingEffects = effect.executingEffects.copy();
        this.chooseUseText = effect.chooseUseText;
    }

    public void addEffect(Effect effect) {
        this.executingEffects.add(effect);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = game.getObject(source);
        if (controller != null && sourceObject != null) {
            String message;
            String costValueMessage;
            Cost costToPay;
            if (this.cost != null) {
                costToPay = this.cost.copy();
                costValueMessage = costToPay.getText();
            } else {
                costToPay = ManaUtil.createManaCost(this.genericMana, game, source, this);
                costValueMessage = "{" + this.genericMana.calculate(game, source, this) + "}";
            }
            if (this.chooseUseText == null) {
                String effectText = this.executingEffects.getText(source.getModes().getMode());
                message = "Pay " + costValueMessage + " to prevent (" + effectText.substring(0, effectText.length() - 1) + ")?";
            } else {
                message = this.chooseUseText;
            }
            message = CardUtil.replaceSourceName(message, sourceObject.getName());
            boolean result = true;
            boolean doEffect = true;
            for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                Player player = game.getPlayer(playerId);
                if (player == null || !player.canRespond() || !costToPay.canPay(source, source, player.getId(), game) || !player.chooseUse(Outcome.Detriment, message, source, game)) continue;
                costToPay.clearPaid();
                if (!costToPay.pay(source, game, source, player.getId(), false, null)) continue;
                if (!game.isSimulation()) {
                    game.informPlayers(player.getLogName() + " pays the cost to prevent the effect");
                }
                doEffect = false;
                break;
            }
            if (doEffect) {
                for (Effect effect : this.executingEffects) {
                    effect.setTargetPointer(this.getTargetPointer().copy());
                    if (effect instanceof OneShotEffect) {
                        result &= effect.apply(game, source);
                        continue;
                    }
                    game.addEffect((ContinuousEffect)effect, source);
                }
            }
            return result;
        }
        return false;
    }

    protected Player getPayingPlayer(Game game, Ability source) {
        return game.getPlayer(source.getControllerId());
    }

    @Override
    public String getText(Mode mode) {
        if (!this.staticText.isEmpty()) {
            return this.staticText;
        }
        StringBuilder sb = new StringBuilder();
        if (this.cost != null) {
            sb.append(this.cost.getText());
        } else {
            sb.append("{X}");
        }
        if (this.genericMana != null && !this.genericMana.getMessage().isEmpty()) {
            sb.append(", where X is ");
            sb.append(this.genericMana.getMessage());
        }
        String effectsText = this.executingEffects.getText(mode);
        return effectsText.substring(0, effectsText.length() - 1) + " unless any player pays " + sb.toString();
    }

    @Override
    public DoUnlessAnyPlayerPaysEffect copy() {
        return new DoUnlessAnyPlayerPaysEffect(this);
    }
}

