/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.costs.Cost;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.Effects;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;
import mage.util.ManaUtil;

public class DoUnlessTargetPlayerOrTargetsControllerPaysEffect
extends OneShotEffect {
    protected Effects executingEffects = new Effects(new Effect[0]);
    private Effect otherwiseEffect;
    private Cost cost;
    private DynamicValue genericMana;
    private String chooseUseText;

    public DoUnlessTargetPlayerOrTargetsControllerPaysEffect(Effect effect, Cost cost) {
        this(effect, cost, null);
    }

    public DoUnlessTargetPlayerOrTargetsControllerPaysEffect(Effect effect, Cost cost, String chooseUseText) {
        this(effect, null, cost, chooseUseText);
    }

    public DoUnlessTargetPlayerOrTargetsControllerPaysEffect(Effect effect, Effect otherwiseEffect, Cost cost, String chooseUseText) {
        super(Outcome.Detriment);
        this.executingEffects.add(effect);
        this.otherwiseEffect = otherwiseEffect;
        this.cost = cost;
        this.chooseUseText = chooseUseText;
    }

    public DoUnlessTargetPlayerOrTargetsControllerPaysEffect(Effect effect, DynamicValue genericMana) {
        super(Outcome.Detriment);
        this.executingEffects.add(effect);
        this.genericMana = genericMana;
    }

    protected DoUnlessTargetPlayerOrTargetsControllerPaysEffect(DoUnlessTargetPlayerOrTargetsControllerPaysEffect effect) {
        super(effect);
        this.executingEffects = effect.executingEffects.copy();
        this.otherwiseEffect = effect.otherwiseEffect;
        if (effect.cost != null) {
            this.cost = effect.cost.copy();
        }
        if (effect.genericMana != null) {
            this.genericMana = effect.genericMana.copy();
        }
        this.chooseUseText = effect.chooseUseText;
    }

    public void addEffect(Effect effect) {
        this.executingEffects.add(effect);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        Permanent targetPermanent = this.getTargetPointer().getFirstTargetPermanentOrLKI(game, source);
        if (targetPermanent != null) {
            player = game.getPlayer(targetPermanent.getControllerId());
        }
        MageObject sourceObject = game.getObject(source);
        if (player != null && sourceObject != null) {
            String message;
            String costValueMessage;
            Cost costToPay;
            if (this.cost != null) {
                costToPay = this.cost.copy();
                costValueMessage = costToPay.getText();
            } else {
                costToPay = ManaUtil.createManaCost(this.genericMana, game, source, this);
                costValueMessage = "{" + this.genericMana.calculate(game, source, this) + "}";
            }
            if (this.chooseUseText == null) {
                String effectText = this.executingEffects.getText(source.getModes().getMode());
                message = "Pay " + costValueMessage + " to prevent (" + effectText.substring(0, effectText.length() - 1) + ")?";
            } else {
                message = this.chooseUseText;
            }
            message = CardUtil.replaceSourceName(message, sourceObject.getName());
            boolean result = true;
            boolean doEffect = true;
            if (costToPay.canPay(source, source, player.getId(), game) && player.chooseUse(Outcome.Detriment, message, source, game)) {
                costToPay.clearPaid();
                if (costToPay.pay(source, game, source, player.getId(), false, null)) {
                    if (!game.isSimulation()) {
                        game.informPlayers(player.getLogName() + " pays the cost to prevent the effect");
                    }
                    doEffect = false;
                }
            }
            if (doEffect) {
                for (Effect effect : this.executingEffects) {
                    effect.setTargetPointer(this.getTargetPointer().copy());
                    if (effect instanceof OneShotEffect) {
                        result &= effect.apply(game, source);
                        continue;
                    }
                    game.addEffect((ContinuousEffect)effect, source);
                }
            } else if (this.otherwiseEffect != null) {
                this.otherwiseEffect.setTargetPointer(this.getTargetPointer().copy());
                if (this.otherwiseEffect instanceof OneShotEffect) {
                    result &= this.otherwiseEffect.apply(game, source);
                } else {
                    game.addEffect((ContinuousEffect)this.otherwiseEffect, source);
                }
            }
            return result;
        }
        return false;
    }

    @Override
    public String getText(Mode mode) {
        if (!this.staticText.isEmpty()) {
            return this.staticText;
        }
        String effectsText = this.executingEffects.getText(mode);
        return effectsText.substring(0, effectsText.length() - 1) + " unless its controller pays " + (this.cost != null ? this.cost.getText() : "{X}");
    }

    @Override
    public DoUnlessTargetPlayerOrTargetsControllerPaysEffect copy() {
        return new DoUnlessTargetPlayerOrTargetsControllerPaysEffect(this);
    }
}

