/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.PhaseStep;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

public class DontUntapInControllersUntapStepEnchantedEffect
extends ContinuousRuleModifyingEffectImpl {
    public DontUntapInControllersUntapStepEnchantedEffect() {
        this("creature");
    }

    public DontUntapInControllersUntapStepEnchantedEffect(String description) {
        super(Duration.WhileOnBattlefield, Outcome.Removal, false, true);
        this.staticText = "Enchanted " + description + " doesn't untap during its controller's untap step";
    }

    protected DontUntapInControllersUntapStepEnchantedEffect(DontUntapInControllersUntapStepEnchantedEffect effect) {
        super(effect);
    }

    @Override
    public DontUntapInControllersUntapStepEnchantedEffect copy() {
        return new DontUntapInControllersUntapStepEnchantedEffect(this);
    }

    @Override
    public String getInfoMessage(Ability source, GameEvent event, Game game) {
        Permanent enchanted;
        Permanent enchantment = game.getPermanent(source.getSourceId());
        if (enchantment != null && enchantment.getAttachedTo() != null && (enchanted = game.getPermanent(enchantment.getAttachedTo())) != null) {
            return enchanted.getLogName() + " doesn't untap during its controller's untap step (" + enchantment.getLogName() + ')';
        }
        return null;
    }

    @Override
    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.UNTAP;
    }

    @Override
    public boolean applies(GameEvent event, Ability source, Game game) {
        Permanent permanent;
        Permanent enchantment;
        return game.getTurnStepType() == PhaseStep.UNTAP && (enchantment = game.getPermanent(source.getSourceId())) != null && enchantment.getAttachedTo() != null && event.getTargetId().equals(enchantment.getAttachedTo()) && (permanent = game.getPermanent(enchantment.getAttachedTo())) != null && permanent.isControlledBy(game.getActivePlayerId());
    }
}

