/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import java.util.Set;
import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

public class ExileCardsFromTopOfLibraryControllerEffect
extends OneShotEffect {
    private final int amount;
    private final boolean toUniqueExileZone;
    private final boolean faceDown;

    public ExileCardsFromTopOfLibraryControllerEffect(int amount) {
        this(amount, false);
    }

    public ExileCardsFromTopOfLibraryControllerEffect(int amount, boolean toUniqueExileZone) {
        this(amount, toUniqueExileZone, false);
    }

    public ExileCardsFromTopOfLibraryControllerEffect(int amount, boolean toUniqueExileZone, boolean faceDown) {
        this(amount, toUniqueExileZone, faceDown, false);
    }

    public ExileCardsFromTopOfLibraryControllerEffect(int amount, boolean toUniqueExileZone, boolean faceDown, boolean withFaceDownReminderText) {
        super(Outcome.Exile);
        this.amount = amount;
        this.toUniqueExileZone = toUniqueExileZone;
        this.faceDown = faceDown;
        this.staticText = "exile the top " + (amount > 1 ? CardUtil.numberToText(amount) + " cards" : "card") + " of your library" + (faceDown ? " face down" : "") + (withFaceDownReminderText ? ". <i>(You can't look at it.)</i>" : "");
    }

    protected ExileCardsFromTopOfLibraryControllerEffect(ExileCardsFromTopOfLibraryControllerEffect effect) {
        super(effect);
        this.amount = effect.amount;
        this.toUniqueExileZone = effect.toUniqueExileZone;
        this.faceDown = effect.faceDown;
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Set<Card> cards;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        UUID exileZoneId = null;
        String exileZoneName = "";
        if (this.toUniqueExileZone) {
            MageObject sourceObject = source.getSourceObject(game);
            if (sourceObject == null) {
                return false;
            }
            exileZoneId = CardUtil.getExileZoneId(game, source);
            exileZoneName = CardUtil.createObjectRelatedWindowTitle(source, game, null);
        }
        if ((cards = controller.getLibrary().getTopCards(game, this.amount)).isEmpty()) {
            return true;
        }
        boolean exiledSuccessfully = false;
        for (Card card : cards) {
            card.setFaceDown(this.faceDown, game);
            exiledSuccessfully |= controller.moveCardsToExile(card, source, game, !this.faceDown, exileZoneId, exileZoneName);
            card.setFaceDown(this.faceDown, game);
        }
        return exiledSuccessfully;
    }

    @Override
    public ExileCardsFromTopOfLibraryControllerEffect copy() {
        return new ExileCardsFromTopOfLibraryControllerEffect(this);
    }
}

