/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.common.delayed.AtTheBeginOfNextEndStepDelayedTriggeredAbility;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ReturnToBattlefieldUnderOwnerControlTargetEffect;
import mage.abilities.effects.common.ReturnToBattlefieldUnderYourControlTargetEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.FixedTargets;
import mage.util.CardUtil;

public class ExileReturnBattlefieldNextEndStepTargetEffect
extends OneShotEffect {
    private boolean yourControl;
    private boolean textThatCard;
    private boolean exiledOnly;

    public ExileReturnBattlefieldNextEndStepTargetEffect() {
        super(Outcome.Neutral);
        this.yourControl = false;
        this.textThatCard = true;
        this.exiledOnly = false;
    }

    protected ExileReturnBattlefieldNextEndStepTargetEffect(ExileReturnBattlefieldNextEndStepTargetEffect effect) {
        super(effect);
        this.yourControl = effect.yourControl;
        this.textThatCard = effect.textThatCard;
        this.exiledOnly = effect.exiledOnly;
    }

    public ExileReturnBattlefieldNextEndStepTargetEffect underYourControl(boolean yourControl) {
        this.yourControl = yourControl;
        return this;
    }

    public ExileReturnBattlefieldNextEndStepTargetEffect withTextThatCard(boolean textThatCard) {
        this.textThatCard = textThatCard;
        return this;
    }

    public ExileReturnBattlefieldNextEndStepTargetEffect returnExiledOnly(boolean exiledOnly) {
        this.exiledOnly = exiledOnly;
        return this;
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        Set toExile = this.getTargetPointer().getTargets(game, source).stream().map(game::getPermanent).filter(Objects::nonNull).collect(Collectors.toCollection(LinkedHashSet::new));
        if (toExile.isEmpty()) {
            return false;
        }
        controller.moveCardsToExile(toExile, source, game, true, CardUtil.getExileZoneId(game, source), CardUtil.getSourceName(game, source));
        OneShotEffect effect = this.yourControl ? new ReturnToBattlefieldUnderYourControlTargetEffect(this.exiledOnly) : new ReturnToBattlefieldUnderOwnerControlTargetEffect(false, this.exiledOnly);
        effect.setTargetPointer(new FixedTargets(toExile.stream().map(Card::getMainCard).collect(Collectors.toSet()), game));
        game.addDelayedTriggeredAbility(new AtTheBeginOfNextEndStepDelayedTriggeredAbility(effect), source);
        return true;
    }

    @Override
    public ExileReturnBattlefieldNextEndStepTargetEffect copy() {
        return new ExileReturnBattlefieldNextEndStepTargetEffect(this);
    }

    @Override
    public String getText(Mode mode) {
        if (this.staticText != null && !this.staticText.isEmpty()) {
            return this.staticText;
        }
        String text = "exile " + this.getTargetPointer().describeTargets(mode.getTargets(), "that creature") + ". Return ";
        boolean plural = this.getTargetPointer().isPlural(mode.getTargets());
        text = this.exiledOnly ? text + (plural ? "the exiled cards" : "the exiled card") : (this.textThatCard ? text + (plural ? "those cards" : "that card") : text + (plural ? "them" : "it"));
        text = text + " to the battlefield";
        text = this.yourControl ? text + " under your control" : text + " under " + (plural ? "their" : "its") + " owner's control";
        return text + " at the beginning of the next end step";
    }
}

