/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import java.util.LinkedHashSet;
import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.stack.Spell;
import mage.game.stack.StackObject;
import mage.players.Player;
import mage.util.CardUtil;

public class ExileTargetEffect
extends OneShotEffect {
    private final Zone onlyFromZone;
    protected String exileZone = null;
    protected UUID exileId = null;
    private boolean toSourceExileZone = false;
    private boolean withName = true;

    public ExileTargetEffect(String effectText) {
        this();
        this.staticText = effectText;
    }

    public ExileTargetEffect() {
        this(null, "");
    }

    public ExileTargetEffect(UUID exileId, String exileZone) {
        this(exileId, exileZone, null);
    }

    public ExileTargetEffect(UUID exileId, String exileZone, Zone onlyFromZone) {
        super(Outcome.Exile);
        this.exileZone = exileZone;
        this.exileId = exileId;
        this.onlyFromZone = onlyFromZone;
    }

    protected ExileTargetEffect(ExileTargetEffect effect) {
        super(effect);
        this.exileZone = effect.exileZone;
        this.exileId = effect.exileId;
        this.onlyFromZone = effect.onlyFromZone;
        this.toSourceExileZone = effect.toSourceExileZone;
        this.withName = effect.withName;
    }

    @Override
    public ExileTargetEffect copy() {
        return new ExileTargetEffect(this);
    }

    public ExileTargetEffect setToSourceExileZone(boolean toSourceExileZone) {
        this.toSourceExileZone = toSourceExileZone;
        return this;
    }

    public void setWithName(boolean withName) {
        this.withName = withName;
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            LinkedHashSet<Card> toExile = new LinkedHashSet<Card>();
            for (UUID targetId : this.getTargetPointer().getTargets(game, source)) {
                Permanent permanent = game.getPermanent(targetId);
                if (permanent != null && permanent.isPhasedIn()) {
                    Zone currentZone = game.getState().getZone(permanent.getId());
                    if (currentZone == Zone.EXILED || this.onlyFromZone != null && this.onlyFromZone != Zone.BATTLEFIELD) continue;
                    toExile.add(permanent);
                    continue;
                }
                Card card = game.getCard(targetId);
                if (card != null) {
                    Zone currentZone = game.getState().getZone(card.getId());
                    if (currentZone == Zone.EXILED || this.onlyFromZone != null && this.onlyFromZone != currentZone) continue;
                    toExile.add(card);
                    continue;
                }
                StackObject stackObject = game.getStack().getStackObject(targetId);
                if (!(stackObject instanceof Spell)) continue;
                toExile.add((Spell)stackObject);
            }
            if (this.toSourceExileZone) {
                MageObject sourceObject = source.getSourceObject(game);
                this.exileId = CardUtil.getExileZoneId(game, source.getSourceId(), source.getStackMomentSourceZCC());
                if (sourceObject != null) {
                    this.exileZone = sourceObject.getIdName();
                }
            }
            controller.moveCardsToExile(toExile, source, game, this.withName, this.exileId, this.exileZone);
            return true;
        }
        return false;
    }

    @Override
    public String getText(Mode mode) {
        if (this.staticText != null && !this.staticText.isEmpty()) {
            return this.staticText;
        }
        return "exile " + this.getTargetPointer().describeTargets(mode.getTargets(), "that permanent");
    }
}

