/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ExileTopCardPlayEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.ExileZone;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.util.CardUtil;

public class ExileTopCardPlayUntilExileAnotherEffect
extends OneShotEffect {
    public ExileTopCardPlayUntilExileAnotherEffect() {
        this(false, "that card");
    }

    public ExileTopCardPlayUntilExileAnotherEffect(boolean withInterveningIf) {
        this(withInterveningIf, "that card");
    }

    public ExileTopCardPlayUntilExileAnotherEffect(String cardDescriptor) {
        this(false, cardDescriptor);
    }

    public ExileTopCardPlayUntilExileAnotherEffect(boolean withInterveningIf, String cardDescriptor) {
        super(Outcome.DrawCard);
        this.staticText = this.makeText(withInterveningIf, cardDescriptor);
    }

    private ExileTopCardPlayUntilExileAnotherEffect(ExileTopCardPlayUntilExileAnotherEffect effect) {
        super(effect);
    }

    @Override
    public OneShotEffect copy() {
        return new ExileTopCardPlayUntilExileAnotherEffect();
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null || !controller.getLibrary().hasCards()) {
            return false;
        }
        Card card = controller.getLibrary().getFromTop(game);
        if (card == null) {
            return false;
        }
        UUID exileId = CardUtil.getExileZoneId(game, source);
        String exileName = CardUtil.getSourceIdName(game, source);
        controller.moveCardsToExile(card, source, game, true, exileId, exileName);
        game.processAction();
        if (!Zone.EXILED.equals((Object)game.getState().getZone(card.getId()))) {
            return true;
        }
        ExileTopCardPlayEffect effect = new ExileTopCardPlayEffect(exileId);
        effect.setTargetPointer(new FixedTarget(card.getMainCard(), game));
        game.addEffect(effect, source);
        ExileZone exileZone = game.getExile().getExileZone(exileId);
        if (exileZone == null) {
            return true;
        }
        Set<Card> inExileZone = exileZone.getCards(game);
        for (Card cardInExile : inExileZone) {
            if (cardInExile.getMainCard().getId().equals(card.getMainCard().getId())) continue;
            game.getExile().moveToMainExileZone(cardInExile, game);
        }
        return true;
    }

    private String makeText(boolean withInterveningIf, String cardDescriptor) {
        StringBuilder sb = new StringBuilder("exile the top card of your library. ");
        if (withInterveningIf) {
            sb.append("If you do, you may play ");
        } else {
            sb.append("You may play ");
        }
        sb.append(cardDescriptor);
        sb.append(" until you exile another card with {this}.");
        return sb.toString();
    }
}

