/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import java.util.Set;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.StaticValue;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.asthought.PlayFromNotOwnHandZoneTargetEffect;
import mage.cards.Card;
import mage.cards.CardsImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInExile;
import mage.target.targetpointer.FixedTargets;
import mage.util.CardUtil;

public class ExileTopXMayPlayUntilEffect
extends OneShotEffect {
    private final DynamicValue amount;
    private final boolean chooseOne;
    private final Duration duration;

    public ExileTopXMayPlayUntilEffect(int amount, Duration duration) {
        this(amount, false, duration);
    }

    public ExileTopXMayPlayUntilEffect(int amount, boolean chooseOne, Duration duration) {
        this(StaticValue.get(amount), chooseOne, duration);
    }

    public ExileTopXMayPlayUntilEffect(DynamicValue amount, boolean chooseOne, Duration duration) {
        super(Outcome.Benefit);
        this.amount = amount.copy();
        this.chooseOne = chooseOne;
        this.duration = duration;
        this.makeText(amount.toString().equals("1") || chooseOne ? "that card" : "those cards", duration == Duration.EndOfTurn);
    }

    protected ExileTopXMayPlayUntilEffect(ExileTopXMayPlayUntilEffect effect) {
        super(effect);
        this.amount = effect.amount.copy();
        this.chooseOne = effect.chooseOne;
        this.duration = effect.duration;
    }

    @Override
    public ExileTopXMayPlayUntilEffect copy() {
        return new ExileTopXMayPlayUntilEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        int resolvedAmount = this.amount.calculate(game, source, this);
        CardsImpl cards = new CardsImpl(controller.getLibrary().getTopCards(game, resolvedAmount));
        if (cards.isEmpty()) {
            return true;
        }
        controller.moveCardsToExile(cards.getCards(game), source, game, true, CardUtil.getExileZoneId(game, source), CardUtil.getSourceName(game, source));
        cards.retainZone(Zone.EXILED, game);
        if (this.chooseOne && cards.size() > 1) {
            TargetCardInExile target = new TargetCardInExile(StaticFilters.FILTER_CARD);
            target.withNotTarget(true);
            controller.choose(this.outcome, cards, target, source, game);
            cards.removeIf(uuid -> !uuid.equals(target.getFirstTarget()));
        }
        if (cards.isEmpty()) {
            return true;
        }
        game.addEffect(new PlayFromNotOwnHandZoneTargetEffect(Zone.EXILED, this.duration).setTargetPointer(new FixedTargets(cards, game)), source);
        this.effectCards(game, source, cards.getCards(game));
        return true;
    }

    protected void effectCards(Game game, Ability source, Set<Card> cards) {
    }

    public ExileTopXMayPlayUntilEffect withTextOptions(String refCardText, boolean durationRuleAtEnd) {
        this.makeText(refCardText, durationRuleAtEnd);
        return this;
    }

    private void makeText(String refCardText, boolean durationRuleAtEnd) {
        String text = "exile the top ";
        boolean singular = this.amount.toString().equals("1");
        text = text + (singular ? "card" : CardUtil.numberToText(this.amount.toString()) + " cards");
        text = this.amount.toString().equals("X") && !this.amount.getMessage().isEmpty() ? text + " of your library, where X is " + this.amount.getMessage() + ". " : text + " of your library. ";
        if (this.chooseOne) {
            text = text + "Choose one of them. ";
        }
        text = durationRuleAtEnd ? text + "You may play " + refCardText + ' ' + (this.duration == Duration.EndOfTurn ? "this turn" : this.duration.toString()) : text + CardUtil.getTextWithFirstCharUpperCase(this.duration.toString()) + ", you may play " + refCardText;
        this.staticText = text;
    }
}

