/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.common.delayed.OnLeaveReturnExiledAbility;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ExileTargetEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

public class ExileUntilSourceLeavesEffect
extends OneShotEffect {
    private final Zone returnToZone;

    public ExileUntilSourceLeavesEffect() {
        this(Zone.BATTLEFIELD);
    }

    public ExileUntilSourceLeavesEffect(Zone returnToZone) {
        super(Outcome.Removal);
        this.returnToZone = returnToZone;
    }

    protected ExileUntilSourceLeavesEffect(ExileUntilSourceLeavesEffect effect) {
        super(effect);
        this.returnToZone = effect.returnToZone;
    }

    @Override
    public ExileUntilSourceLeavesEffect copy() {
        return new ExileUntilSourceLeavesEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (permanent == null) {
            return false;
        }
        ExileTargetEffect effect = new ExileTargetEffect(CardUtil.getCardExileZoneId(game, source), permanent.getIdName());
        effect.setTargetPointer(this.getTargetPointer().copy());
        if (effect.apply(game, source)) {
            game.addDelayedTriggeredAbility(new OnLeaveReturnExiledAbility(this.returnToZone), source);
            return true;
        }
        return false;
    }

    @Override
    public String getText(Mode mode) {
        if (this.staticText != null && !this.staticText.isEmpty()) {
            return this.staticText;
        }
        return "exile " + this.getTargetPointer().describeTargets(mode.getTargets(), "that creature") + " until {this} leaves the battlefield";
    }
}

