/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.choices.ChoiceImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTargets;
import mage.util.CardUtil;

public class GainsChoiceOfAbilitiesEffect
extends OneShotEffect {
    private final Map<String, Ability> abilityMap;
    private final boolean includeEnd;
    private final TargetType affects;
    private final String targetDescription;

    public GainsChoiceOfAbilitiesEffect(Ability ... abilities) {
        this(TargetType.Target, null, true, abilities);
    }

    public GainsChoiceOfAbilitiesEffect(TargetType affects, Ability ... abilities) {
        this(affects, null, true, abilities);
    }

    public GainsChoiceOfAbilitiesEffect(TargetType affects, String targetDescription, boolean includeEnd, Ability ... abilities) {
        super(Outcome.AddAbility);
        this.affects = affects;
        this.targetDescription = targetDescription;
        this.includeEnd = includeEnd;
        this.abilityMap = new LinkedHashMap<String, Ability>();
        for (Ability ability : abilities) {
            this.abilityMap.put(CardUtil.stripReminderText(ability.getRule()), ability);
        }
    }

    protected GainsChoiceOfAbilitiesEffect(GainsChoiceOfAbilitiesEffect effect) {
        super(effect);
        this.affects = effect.affects;
        this.abilityMap = CardUtil.deepCopyObject(effect.abilityMap);
        this.targetDescription = effect.targetDescription;
        this.includeEnd = effect.includeEnd;
    }

    @Override
    public GainsChoiceOfAbilitiesEffect copy() {
        return new GainsChoiceOfAbilitiesEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        ArrayList<Permanent> permanents = new ArrayList<Permanent>();
        if (this.affects == TargetType.Source || this.affects == TargetType.Both) {
            permanents.add(source.getSourcePermanentIfItStillExists(game));
        }
        if (this.affects == TargetType.Target || this.affects == TargetType.Both) {
            for (UUID p : this.getTargetPointer().getTargets(game, source)) {
                permanents.add(game.getPermanent(p));
            }
        }
        permanents.removeIf(Objects::isNull);
        if (player == null || permanents.isEmpty()) {
            return false;
        }
        ChoiceImpl choice = new ChoiceImpl(true);
        choice.setMessage("Choose an ability to gain");
        choice.setChoices(new HashSet<String>(this.abilityMap.keySet()));
        player.choose(this.outcome, choice, game);
        Ability ability = this.abilityMap.get(choice.getChoice());
        if (ability != null) {
            game.addEffect(new GainAbilityTargetEffect(ability, Duration.EndOfTurn).setTargetPointer(new FixedTargets(permanents, game)), source);
        }
        return true;
    }

    @Override
    public String getText(Mode mode) {
        if (this.staticText != null && !this.staticText.isEmpty()) {
            return this.staticText;
        }
        StringBuilder sb = new StringBuilder();
        if (this.targetDescription != null) {
            if (this.targetDescription.isEmpty()) {
                sb.append("gains");
            } else {
                sb.append(this.targetDescription);
                sb.append(" gains");
            }
        } else {
            switch (this.affects) {
                case Source: {
                    sb.append("{this} gains");
                    break;
                }
                case Target: {
                    sb.append(this.getTargetPointer().describeTargets(mode.getTargets(), "that creature"));
                    sb.append(" gains");
                    break;
                }
                case Both: {
                    sb.append("{this} and ");
                    sb.append(this.getTargetPointer().describeTargets(mode.getTargets(), "that creature"));
                    sb.append(" both gain");
                }
            }
        }
        sb.append(" your choice of ");
        String[] abilitiesText = this.abilityMap.keySet().toArray(new String[0]);
        if (this.abilityMap.size() == 2) {
            sb.append(abilitiesText[0]).append(" or ").append(abilitiesText[1]);
        } else if (this.abilityMap.size() > 2) {
            for (int i = 0; i < this.abilityMap.size() - 1; ++i) {
                sb.append(abilitiesText[i]).append(", ");
            }
            sb.append("or ").append(abilitiesText[this.abilityMap.size() - 1]);
        } else {
            throw new IllegalStateException("Not enough abilities for GainsChoiceOfAbilitiesEffect");
        }
        if (this.includeEnd) {
            sb.append(" until end of turn");
        }
        return sb.toString();
    }

    public static enum TargetType {
        Source,
        Target,
        Both;

    }
}

