/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.asthought.YouMaySpendManaAsAnyColorToCastTargetEffect;
import mage.abilities.effects.common.replacement.ThatSpellGraveyardExileReplacementEffect;
import mage.cards.Card;
import mage.constants.CastManaAdjustment;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.util.CardUtil;

public class MayCastTargetCardEffect
extends OneShotEffect {
    private final Duration duration;
    private final CastManaAdjustment manaAdjustment;
    private final boolean thenExile;

    public MayCastTargetCardEffect(boolean thenExile) {
        this(CastManaAdjustment.NONE, thenExile);
    }

    public MayCastTargetCardEffect(CastManaAdjustment manaAdjustment) {
        this(manaAdjustment, false);
    }

    public MayCastTargetCardEffect(CastManaAdjustment manaAdjustment, boolean thenExile) {
        this(Duration.OneUse, manaAdjustment, thenExile);
    }

    public MayCastTargetCardEffect(Duration duration, boolean thenExile) {
        this(duration, CastManaAdjustment.NONE, thenExile);
    }

    protected MayCastTargetCardEffect(Duration duration, CastManaAdjustment manaAdjustment, boolean thenExile) {
        super(Outcome.Benefit);
        this.duration = duration;
        this.manaAdjustment = manaAdjustment;
        this.thenExile = thenExile;
        if (duration != Duration.OneUse && manaAdjustment != CastManaAdjustment.NONE) {
            throw new IllegalStateException("Wrong code usage, not yet supported duration={" + duration.name() + "}, manaAdjustment={" + manaAdjustment.name() + "}");
        }
    }

    protected MayCastTargetCardEffect(MayCastTargetCardEffect effect) {
        super(effect);
        this.duration = effect.duration;
        this.manaAdjustment = effect.manaAdjustment;
        this.thenExile = effect.thenExile;
    }

    @Override
    public MayCastTargetCardEffect copy() {
        return new MayCastTargetCardEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Card card = game.getCard(this.getTargetPointer().getFirst(game, source));
        if (card == null) {
            return false;
        }
        FixedTarget fixedTarget = new FixedTarget(card, game);
        if (this.duration == Duration.OneUse) {
            Player controller = game.getPlayer(source.getControllerId());
            if (controller == null || !controller.chooseUse(this.outcome, "Cast " + card.getLogName() + '?', source, game)) {
                return false;
            }
            switch (this.manaAdjustment) {
                case NONE: 
                case WITHOUT_PAYING_MANA_COST: {
                    break;
                }
                case AS_THOUGH_ANY_MANA_COLOR: 
                case AS_THOUGH_ANY_MANA_TYPE: {
                    YouMaySpendManaAsAnyColorToCastTargetEffect effect = new YouMaySpendManaAsAnyColorToCastTargetEffect(Duration.Custom, controller.getId(), null);
                    effect.setTargetPointer(fixedTarget.copy());
                    game.addEffect(effect, source);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Wrong code usage, manaAdjustment is not yet supported: " + (Object)((Object)this.manaAdjustment));
                }
            }
            game.getState().setValue("PlayFromNotOwnHandZone" + card.getId(), Boolean.TRUE);
            boolean noMana = this.manaAdjustment == CastManaAdjustment.WITHOUT_PAYING_MANA_COST;
            CardUtil.castSingle(controller, source, game, card, noMana, null);
            game.getState().setValue("PlayFromNotOwnHandZone" + card.getId(), null);
        } else {
            CardUtil.makeCardPlayable(game, source, card, true, this.duration, false);
        }
        if (this.thenExile) {
            ThatSpellGraveyardExileReplacementEffect effect = new ThatSpellGraveyardExileReplacementEffect(true);
            effect.setTargetPointer(fixedTarget.copy());
            game.addEffect(effect, source);
        }
        return true;
    }

    @Override
    public String getText(Mode mode) {
        if (this.staticText != null && !this.staticText.isEmpty()) {
            return this.staticText;
        }
        String text = "you may cast " + this.getTargetPointer().describeTargets(mode.getTargets(), "it");
        if (this.duration == Duration.EndOfTurn) {
            text = text + " this turn";
        } else if (!this.duration.toString().isEmpty()) {
            text = text + this.duration.toString();
        }
        switch (this.manaAdjustment) {
            case NONE: {
                break;
            }
            case WITHOUT_PAYING_MANA_COST: {
                text = text + " without paying its mana cost";
                break;
            }
            case AS_THOUGH_ANY_MANA_COLOR: {
                text = text + ", and mana of any color can be spent to cast that spell";
                break;
            }
            case AS_THOUGH_ANY_MANA_TYPE: {
                text = text + ", and mana of any type can be spent to cast that spell";
                break;
            }
            default: {
                throw new IllegalArgumentException("Wrong code usage, manaAdjustment is not yet supported: " + (Object)((Object)this.manaAdjustment));
            }
        }
        text = text + ".";
        if (this.thenExile) {
            text = text.contains("a graveyard") ? text + " If that spell would be put into a graveyard, exile it instead." : text + " If that spell would be put into your graveyard, exile it instead.";
        }
        return text;
    }
}

