/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.StaticValue;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

public class MillCardsEachPlayerEffect
extends OneShotEffect {
    private final DynamicValue numberCards;
    private final TargetController targetController;

    public MillCardsEachPlayerEffect(int numberCards, TargetController targetController) {
        this(StaticValue.get(numberCards), targetController);
    }

    public MillCardsEachPlayerEffect(DynamicValue numberCards, TargetController targetController) {
        super(Outcome.Discard);
        this.numberCards = numberCards;
        this.targetController = targetController;
        this.staticText = this.setText();
    }

    private MillCardsEachPlayerEffect(MillCardsEachPlayerEffect effect) {
        super(effect);
        this.numberCards = effect.numberCards;
        this.targetController = effect.targetController;
    }

    @Override
    public MillCardsEachPlayerEffect copy() {
        return new MillCardsEachPlayerEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player != null) {
            switch (this.targetController) {
                case OPPONENT: {
                    for (UUID playerId : game.getOpponents(source.getControllerId())) {
                        this.putCardsToGravecard(playerId, source, game);
                    }
                    break;
                }
                case ANY: 
                case EACH_PLAYER: {
                    for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
                        this.putCardsToGravecard(playerId, source, game);
                    }
                    break;
                }
                case NOT_YOU: {
                    for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
                        if (playerId.equals(source.getSourceId())) continue;
                        this.putCardsToGravecard(playerId, source, game);
                    }
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("TargetController type not supported.");
                }
            }
            return true;
        }
        return false;
    }

    private void putCardsToGravecard(UUID playerId, Ability source, Game game) {
        Player player = game.getPlayer(playerId);
        if (player != null) {
            player.millCards(this.numberCards.calculate(game, source, this), source, game);
        }
    }

    private String setText() {
        StringBuilder sb = new StringBuilder();
        switch (this.targetController) {
            case OPPONENT: {
                sb.append("each opponent ");
                break;
            }
            case ANY: 
            case EACH_PLAYER: {
                sb.append("each player ");
                break;
            }
            case NOT_YOU: {
                sb.append("each other player ");
                break;
            }
            default: {
                throw new UnsupportedOperationException("TargetController type not supported.");
            }
        }
        sb.append("mills ");
        switch (this.numberCards.toString()) {
            case "1": {
                sb.append("a card");
                break;
            }
            case "X": {
                sb.append("X cards, where X is ");
                sb.append(this.numberCards.getMessage());
                break;
            }
            default: {
                sb.append(CardUtil.numberToText(this.numberCards.toString()));
                sb.append(" cards");
            }
        }
        return sb.toString();
    }
}

