/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.StaticValue;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

public class MillCardsTargetEffect
extends OneShotEffect {
    private final DynamicValue numberCards;

    public MillCardsTargetEffect(int numberCards) {
        this(StaticValue.get(numberCards));
    }

    public MillCardsTargetEffect(DynamicValue numberCards) {
        super(Outcome.Discard);
        this.numberCards = numberCards;
    }

    protected MillCardsTargetEffect(MillCardsTargetEffect effect) {
        super(effect);
        this.numberCards = effect.numberCards;
    }

    @Override
    public MillCardsTargetEffect copy() {
        return new MillCardsTargetEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        for (UUID playerId : this.getTargetPointer().getTargets(game, source)) {
            Player player = game.getPlayer(playerId);
            if (player == null) continue;
            player.millCards(this.numberCards.calculate(game, source, this), source, game);
        }
        return true;
    }

    @Override
    public String getText(Mode mode) {
        if (this.staticText != null && !this.staticText.isEmpty()) {
            return this.staticText;
        }
        StringBuilder sb = new StringBuilder(this.getTargetPointer().describeTargets(mode.getTargets(), "that player"));
        sb.append(" mills ");
        String message = this.numberCards.getMessage();
        if (message.isEmpty()) {
            if (this.numberCards.toString().equals("1")) {
                sb.append("a card");
            } else {
                sb.append(CardUtil.numberToText(this.numberCards.toString()));
                sb.append(" cards");
            }
        } else {
            sb.append("X cards, where X is the number of ");
            sb.append(message);
        }
        return sb.toString();
    }
}

