/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import mage.abilities.Ability;
import mage.abilities.effects.PreventionEffectImpl;
import mage.constants.Duration;
import mage.filter.FilterPermanent;
import mage.game.Game;
import mage.game.events.DamageEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

public class PreventAllDamageByAllPermanentsEffect
extends PreventionEffectImpl {
    protected final FilterPermanent filter;

    public PreventAllDamageByAllPermanentsEffect(Duration duration) {
        this(null, duration, false);
    }

    public PreventAllDamageByAllPermanentsEffect(Duration duration, boolean onlyCombat) {
        this(null, duration, onlyCombat);
    }

    public PreventAllDamageByAllPermanentsEffect(FilterPermanent filter, Duration duration, boolean onlyCombat) {
        super(duration, Integer.MAX_VALUE, onlyCombat);
        this.filter = filter;
        this.setText();
    }

    protected PreventAllDamageByAllPermanentsEffect(PreventAllDamageByAllPermanentsEffect effect) {
        super(effect);
        this.filter = effect.filter;
    }

    @Override
    public PreventAllDamageByAllPermanentsEffect copy() {
        return new PreventAllDamageByAllPermanentsEffect(this);
    }

    @Override
    public boolean applies(GameEvent event, Ability source, Game game) {
        DamageEvent damageEvent;
        if (super.applies(event, source, game) && event instanceof DamageEvent && event.getAmount() > 0 && ((damageEvent = (DamageEvent)event).isCombatDamage() || !this.onlyCombat)) {
            if (this.filter == null) {
                return true;
            }
            Permanent permanent = game.getPermanent(damageEvent.getSourceId());
            if (this.filter.match(permanent, source.getControllerId(), source, game)) {
                return true;
            }
        }
        return false;
    }

    private void setText() {
        StringBuilder sb = new StringBuilder("prevent all ");
        if (this.onlyCombat) {
            sb.append("combat ");
        }
        sb.append("damage that would be dealt");
        if (this.duration == Duration.EndOfTurn) {
            sb.append(" this turn");
        }
        if (this.filter != null) {
            sb.append(" by ");
            sb.append(this.filter.getMessage());
        }
        this.staticText = sb.toString();
    }
}

