/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.stack.Spell;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInYourGraveyard;
import mage.util.CardUtil;

public class PutOnLibraryTargetEffect
extends OneShotEffect {
    boolean onTop;

    public PutOnLibraryTargetEffect(boolean onTop) {
        super(Outcome.ReturnToHand);
        this.onTop = onTop;
    }

    public PutOnLibraryTargetEffect(boolean onTop, String rule) {
        super(Outcome.ReturnToHand);
        this.onTop = onTop;
        this.staticText = rule;
    }

    protected PutOnLibraryTargetEffect(PutOnLibraryTargetEffect effect) {
        super(effect);
        this.onTop = effect.onTop;
    }

    @Override
    public PutOnLibraryTargetEffect copy() {
        return new PutOnLibraryTargetEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            Card next;
            Iterator iterator;
            CardsImpl cardsPlayer;
            Player owner;
            ArrayList<Card> cards = new ArrayList<Card>();
            ArrayList<Permanent> permanents = new ArrayList<Permanent>();
            for (UUID targetId : this.getTargetPointer().getTargets(game, source)) {
                switch (game.getState().getZone(targetId)) {
                    case BATTLEFIELD: {
                        Permanent permanent = game.getPermanent(targetId);
                        if (permanent == null) break;
                        permanents.add(permanent);
                        break;
                    }
                    case GRAVEYARD: 
                    case EXILED: {
                        Card card = game.getCard(targetId);
                        if (card == null) break;
                        cards.add(card);
                        break;
                    }
                    case STACK: {
                        Card stackSpellCard;
                        Spell spell = game.getSpell(targetId);
                        Card card = stackSpellCard = spell != null ? spell.getCard() : null;
                        if (stackSpellCard == null) break;
                        cards.add(stackSpellCard);
                    }
                }
            }
            while (!cards.isEmpty()) {
                Card card = (Card)cards.iterator().next();
                if (card == null) continue;
                owner = game.getPlayer(card.getOwnerId());
                cardsPlayer = new CardsImpl();
                iterator = cards.iterator();
                while (iterator.hasNext()) {
                    next = (Card)iterator.next();
                    if (!next.isOwnedBy(owner.getId())) continue;
                    cardsPlayer.add(next);
                    iterator.remove();
                }
                if (this.onTop) {
                    owner.putCardsOnTopOfLibrary(cardsPlayer, game, source, true);
                    continue;
                }
                owner.putCardsOnBottomOfLibrary(cardsPlayer, game, source, true);
            }
            while (!permanents.isEmpty()) {
                Permanent permanent = (Permanent)permanents.iterator().next();
                if (permanent == null) continue;
                owner = game.getPlayer(permanent.getOwnerId());
                cardsPlayer = new CardsImpl();
                iterator = permanents.iterator();
                while (iterator.hasNext()) {
                    next = (Permanent)iterator.next();
                    if (!next.isOwnedBy(owner.getId())) continue;
                    cardsPlayer.add(next);
                    iterator.remove();
                }
                if (this.onTop) {
                    owner.putCardsOnTopOfLibrary(cardsPlayer, game, source, true);
                    continue;
                }
                owner.putCardsOnBottomOfLibrary(cardsPlayer, game, source, true);
            }
            return true;
        }
        return false;
    }

    @Override
    public String getText(Mode mode) {
        if (this.staticText != null && !this.staticText.isEmpty()) {
            return this.staticText;
        }
        StringBuilder sb = new StringBuilder();
        Target target = (Target)mode.getTargets().get(0);
        sb.append("put ");
        if (target.getMaxNumberOfTargets() == 0 || target.getMaxNumberOfTargets() == Integer.MAX_VALUE) {
            sb.append("any number of ");
        } else if (target.getMaxNumberOfTargets() != 1 || target.getMinNumberOfTargets() != 1) {
            if (target.getMaxNumberOfTargets() > target.getMinNumberOfTargets()) {
                sb.append("up to ");
            }
            sb.append(CardUtil.numberToText(target.getMaxNumberOfTargets())).append(' ');
        }
        sb.append("target ").append(((Target)mode.getTargets().get(0)).getTargetName()).append(" on ");
        sb.append(this.onTop ? "top" : "the bottom").append(" of ").append(mode.getTargets().get(0) instanceof TargetCardInYourGraveyard ? "your" : "its owner's").append(" library");
        return sb.toString();
    }
}

