/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.effects.RedirectionEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.Target;

public class RedirectDamageFromSourceToTargetEffect
extends RedirectionEffect {
    public RedirectDamageFromSourceToTargetEffect(Duration duration, int amountToRedirect, RedirectionEffect.UsageType usageType) {
        super(duration, amountToRedirect, usageType);
    }

    protected RedirectDamageFromSourceToTargetEffect(RedirectDamageFromSourceToTargetEffect effect) {
        super(effect);
    }

    @Override
    public RedirectDamageFromSourceToTargetEffect copy() {
        return new RedirectDamageFromSourceToTargetEffect(this);
    }

    @Override
    public boolean applies(GameEvent event, Ability source, Game game) {
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (permanent != null && event.getTargetId().equals(source.getSourceId()) && this.getTargetPointer().getFirst(game, source) != null) {
            this.redirectTarget = (Target)source.getTargets().get(0);
            return true;
        }
        return false;
    }

    @Override
    public String getText(Mode mode) {
        if (this.staticText != null && !this.staticText.isEmpty()) {
            return this.staticText;
        }
        return "the next " + this.amountToRedirect + " damage that would be dealt to {this} this turn is dealt to " + this.getTargetPointer().describeTargets(mode.getTargets(), "that creature") + " instead";
    }
}

