/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.effects.common.ReturnToBattlefieldUnderOwnerControlTargetEffect;
import mage.counters.Counter;
import mage.counters.Counters;
import mage.game.Game;
import mage.util.CardUtil;

public class ReturnToBattlefieldUnderOwnerControlWithCounterTargetEffect
extends ReturnToBattlefieldUnderOwnerControlTargetEffect {
    private final Counters counters;
    private final String counterText;

    public ReturnToBattlefieldUnderOwnerControlWithCounterTargetEffect(Counter counter, boolean returnFromExileZoneOnly) {
        this(counter, false, returnFromExileZoneOnly);
    }

    public ReturnToBattlefieldUnderOwnerControlWithCounterTargetEffect(Counter counter, boolean additional, boolean returnFromExileZoneOnly) {
        super(false, returnFromExileZoneOnly);
        this.counters = new Counters(new Counter[0]);
        this.counters.addCounter(counter);
        this.counterText = ReturnToBattlefieldUnderOwnerControlWithCounterTargetEffect.makeText(counter, additional);
    }

    protected ReturnToBattlefieldUnderOwnerControlWithCounterTargetEffect(ReturnToBattlefieldUnderOwnerControlWithCounterTargetEffect effect) {
        super(effect);
        this.counters = effect.counters.copy();
        this.counterText = effect.counterText;
    }

    @Override
    public ReturnToBattlefieldUnderOwnerControlWithCounterTargetEffect copy() {
        return new ReturnToBattlefieldUnderOwnerControlWithCounterTargetEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        for (UUID cardId : this.getCardsToReturn(game, source)) {
            game.setEnterWithCounters(cardId, this.counters.copy());
        }
        return super.apply(game, source);
    }

    private static String makeText(Counter counter, boolean additional) {
        StringBuilder sb = new StringBuilder(" with ");
        if (additional) {
            sb.append(CardUtil.numberToText(counter.getCount(), "an"));
            sb.append(" additional");
        } else {
            sb.append(CardUtil.numberToText(counter.getCount(), "a"));
        }
        sb.append(' ');
        sb.append(counter.getName());
        sb.append(" counter");
        if (counter.getCount() != 1) {
            sb.append('s');
        }
        return sb.toString();
    }

    @Override
    public String getText(Mode mode) {
        if (this.staticText != null && !this.staticText.isEmpty()) {
            return this.staticText;
        }
        return super.getText(mode) + this.counterText + (this.getTargetPointer().isPlural(mode.getTargets()) ? " on them" : " on it");
    }
}

