/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.ExileZone;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

public class ReturnToBattlefieldUnderYourControlSourceEffect
extends OneShotEffect {
    public ReturnToBattlefieldUnderYourControlSourceEffect() {
        super(Outcome.Benefit);
        this.staticText = "return that card to the battlefield under your control";
    }

    protected ReturnToBattlefieldUnderYourControlSourceEffect(ReturnToBattlefieldUnderYourControlSourceEffect effect) {
        super(effect);
    }

    @Override
    public ReturnToBattlefieldUnderYourControlSourceEffect copy() {
        return new ReturnToBattlefieldUnderYourControlSourceEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Card card;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        UUID exileZoneId = CardUtil.getExileZoneId(game, source.getSourceId(), source.getStackMomentSourceZCC());
        ExileZone exileZone = game.getExile().getExileZone(exileZoneId);
        return exileZone != null && exileZone.contains(source.getSourceId()) && (card = game.getCard(source.getSourceId())) != null && controller.moveCards(card, Zone.BATTLEFIELD, source, game);
    }
}

