/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.players.Player;

public class ReturnToHandTargetEffect
extends OneShotEffect {
    public ReturnToHandTargetEffect() {
        super(Outcome.ReturnToHand);
    }

    protected ReturnToHandTargetEffect(ReturnToHandTargetEffect effect) {
        super(effect);
    }

    @Override
    public ReturnToHandTargetEffect copy() {
        return new ReturnToHandTargetEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        ArrayList<UUID> copyIds = new ArrayList<UUID>();
        LinkedHashSet<Card> cards = new LinkedHashSet<Card>();
        for (UUID targetId : this.getTargetPointer().getTargets(game, source)) {
            MageObject mageObject = game.getObject(targetId);
            if (mageObject == null) continue;
            if (mageObject instanceof Spell && mageObject.isCopy()) {
                copyIds.add(targetId);
                continue;
            }
            if (!(mageObject instanceof Card)) continue;
            cards.add((Card)mageObject);
        }
        for (UUID copyId : copyIds) {
            game.getStack().remove(game.getSpell(copyId), game);
        }
        return controller.moveCards(cards, Zone.HAND, source, game);
    }

    @Override
    public String getText(Mode mode) {
        if (this.staticText != null && !this.staticText.isEmpty()) {
            return this.staticText;
        }
        return "return " + this.getTargetPointer().describeTargets(mode.getTargets(), "that creature") + (this.getTargetPointer().isPlural(mode.getTargets()) ? " to their owners' hands" : " to its owner's hand");
    }
}

