/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.game.Game;
import mage.players.Player;

public class RevealHandEachPlayerEffect
extends OneShotEffect {
    private final TargetController targetController;

    public RevealHandEachPlayerEffect() {
        this(TargetController.ANY);
    }

    public RevealHandEachPlayerEffect(TargetController targetController) {
        super(Outcome.Benefit);
        this.targetController = targetController;
    }

    protected RevealHandEachPlayerEffect(RevealHandEachPlayerEffect effect) {
        super(effect);
        this.targetController = effect.targetController;
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = game.getObject(source);
        if (controller == null) {
            return true;
        }
        block4: for (UUID playerId : game.getPlayers().keySet()) {
            Player player = game.getPlayer(playerId);
            if (player == null) continue;
            switch (this.targetController) {
                case NOT_YOU: {
                    if (!playerId.equals(source.getControllerId())) break;
                    continue block4;
                }
                case OPPONENT: {
                    if (game.getOpponents(source.getControllerId()).contains(playerId)) break;
                    continue block4;
                }
            }
            player.revealCards(sourceObject.getIdName() + player.getName(), player.getHand(), game);
        }
        return true;
    }

    @Override
    public RevealHandEachPlayerEffect copy() {
        return new RevealHandEachPlayerEffect(this);
    }

    @Override
    public String getText(Mode mode) {
        if (this.staticText != null && !this.staticText.isEmpty()) {
            return this.staticText;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("each ");
        switch (this.targetController) {
            case NOT_YOU: {
                sb.append("other player");
                break;
            }
            case OPPONENT: {
                sb.append("opponent");
                break;
            }
            case ANY: {
                sb.append("player");
            }
        }
        sb.append(" reveals their hand");
        return sb.toString();
    }
}

