/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

public class RevealPutInHandLoseLifeEffect
extends OneShotEffect {
    public RevealPutInHandLoseLifeEffect() {
        this(false);
    }

    public RevealPutInHandLoseLifeEffect(boolean ifYouDo) {
        super(Outcome.Benefit);
        this.staticText = "reveal the top card of your library and put that card into your hand. " + (ifYouDo ? "If you do, y" : "Y") + "ou lose life equal to its mana value";
    }

    private RevealPutInHandLoseLifeEffect(RevealPutInHandLoseLifeEffect effect) {
        super(effect);
    }

    @Override
    public RevealPutInHandLoseLifeEffect copy() {
        return new RevealPutInHandLoseLifeEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        Card card = player.getLibrary().getFromTop(game);
        if (card == null) {
            return false;
        }
        player.revealCards(source, (Cards)new CardsImpl(card), game);
        player.moveCards(card, Zone.HAND, source, game);
        player.loseLife(card.getManaValue(), game, source, false);
        return true;
    }
}

