/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.StaticValue;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.common.TargetSacrifice;
import mage.util.CardUtil;

public class SacrificeAllEffect
extends OneShotEffect {
    private final DynamicValue amount;
    private final FilterPermanent filter;
    private final boolean onlyOpponents;
    private static final String VALUE_KEY = "sacrificeAllEffect_permanentsList";

    public SacrificeAllEffect(FilterPermanent filter) {
        this(1, filter);
    }

    public SacrificeAllEffect(int amount, FilterPermanent filter) {
        this(StaticValue.get(amount), filter);
    }

    public SacrificeAllEffect(DynamicValue amount, FilterPermanent filter) {
        this(amount, filter, false);
    }

    protected SacrificeAllEffect(DynamicValue amount, FilterPermanent filter, boolean onlyOpponents) {
        super(Outcome.Sacrifice);
        this.amount = amount;
        this.filter = filter;
        this.onlyOpponents = onlyOpponents;
        this.setText();
    }

    protected SacrificeAllEffect(SacrificeAllEffect effect) {
        super(effect);
        this.amount = effect.amount;
        this.filter = effect.filter.copy();
        this.onlyOpponents = effect.onlyOpponents;
    }

    @Override
    public SacrificeAllEffect copy() {
        return new SacrificeAllEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        int num = this.amount.calculate(game, source, this);
        if (num < 1) {
            return false;
        }
        HashSet<UUID> perms = new HashSet<UUID>();
        for (UUID playerId : this.onlyOpponents ? game.getOpponents(source.getControllerId()) : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            int numTargets;
            Player player = game.getPlayer(playerId);
            if (player == null || (numTargets = Math.min(num, game.getBattlefield().count(TargetSacrifice.makeFilter(this.filter), player.getId(), source, game))) < 1) continue;
            TargetSacrifice target = new TargetSacrifice(numTargets, this.filter);
            target.choose(Outcome.Sacrifice, player.getId(), source, game);
            perms.addAll(target.getTargets());
        }
        ArrayList<Permanent> sacraficedPermanents = new ArrayList<Permanent>();
        for (UUID permID : perms) {
            Permanent permanent = game.getPermanent(permID);
            if (permanent == null || !permanent.sacrifice(source, game)) continue;
            sacraficedPermanents.add(permanent.copy());
        }
        SacrificeAllEffect.saveSacrificedPermanentsList(source.getSourceId(), game, sacraficedPermanents);
        return true;
    }

    public static void saveSacrificedPermanentsList(UUID sourceObjectId, Game game, List<Permanent> list) {
        game.getState().setValue(CardUtil.getCardZoneString(VALUE_KEY, sourceObjectId, game), list);
    }

    public static List<Permanent> getSacrificedPermanentsList(UUID sourceObjectId, Game game, boolean previous) {
        return (List)game.getState().getValue(CardUtil.getCardZoneString(VALUE_KEY, sourceObjectId, game, previous));
    }

    private void setText() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.onlyOpponents ? "each opponent sacrifices " : "each player sacrifices ");
        switch (this.amount.toString()) {
            case "X": {
                sb.append(this.amount.toString());
                sb.append(' ');
                sb.append(this.filter.getMessage());
                break;
            }
            case "1": {
                sb.append(CardUtil.addArticle(this.filter.getMessage()));
                break;
            }
            default: {
                sb.append(CardUtil.numberToText(this.amount.toString(), "a"));
                sb.append(' ');
                sb.append(this.filter.getMessage());
            }
        }
        if (!this.filter.getMessage().contains("with")) {
            sb.append(" of their choice");
        }
        this.staticText = sb.toString();
    }
}

