/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;

public class SacrificeSourceEffect
extends OneShotEffect {
    private final boolean controllerSacrifices;

    public SacrificeSourceEffect() {
        this(false);
    }

    public SacrificeSourceEffect(boolean controllerSacrifices) {
        super(Outcome.Sacrifice);
        this.controllerSacrifices = controllerSacrifices;
        this.staticText = controllerSacrifices ? "{this}'s controller sacrifices it" : "sacrifice {this}";
    }

    protected SacrificeSourceEffect(SacrificeSourceEffect effect) {
        super(effect);
        this.controllerSacrifices = effect.controllerSacrifices;
    }

    @Override
    public SacrificeSourceEffect copy() {
        return new SacrificeSourceEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        MageObject sourceObject = source.getSourceObjectIfItStillExists(game);
        if (sourceObject == null && game.getState().getZone(source.getSourceId()).equals((Object)Zone.BATTLEFIELD) && source.getStackMomentSourceZCC() + 1 == game.getState().getZoneChangeCounter(source.getSourceId())) {
            sourceObject = game.getPermanent(source.getSourceId());
        }
        if (sourceObject instanceof Permanent) {
            Permanent permanent = (Permanent)sourceObject;
            if (this.controllerSacrifices || source.isControlledBy(permanent.getControllerId())) {
                return permanent.sacrifice(source, game);
            }
            return true;
        }
        return false;
    }
}

