/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.costs.Cost;
import mage.abilities.costs.mana.ManaCost;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;
import mage.util.ManaUtil;

public class SacrificeSourceUnlessPaysEffect
extends OneShotEffect {
    protected Cost cost;
    protected DynamicValue genericMana;

    public SacrificeSourceUnlessPaysEffect(Cost cost) {
        super(Outcome.Sacrifice);
        this.cost = cost;
    }

    public SacrificeSourceUnlessPaysEffect(DynamicValue genericMana) {
        super(Outcome.Detriment);
        this.genericMana = genericMana;
    }

    protected SacrificeSourceUnlessPaysEffect(SacrificeSourceUnlessPaysEffect effect) {
        super(effect);
        if (effect.cost != null) {
            this.cost = effect.cost.copy();
        }
        if (effect.genericMana != null) {
            this.genericMana = effect.genericMana.copy();
        }
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent sourcePermanent = game.getPermanentOrLKIBattlefield(source.getSourceId());
        if (player != null && sourcePermanent != null) {
            String costValueMessage;
            Cost costToPay;
            if (this.cost != null) {
                costToPay = this.cost.copy();
                costValueMessage = costToPay.getText();
            } else {
                costToPay = ManaUtil.createManaCost(this.genericMana, game, source, this);
                costValueMessage = "{" + this.genericMana.calculate(game, source, this) + "}";
            }
            String message = "";
            String logMessage = "";
            if (costToPay instanceof ManaCost) {
                message = message + "Pay " + costValueMessage;
                logMessage = logMessage + "pay " + costValueMessage;
            } else if (costValueMessage.length() > 1) {
                message = message + CardUtil.getTextWithFirstCharUpperCase(costValueMessage);
                logMessage = logMessage + costValueMessage;
            }
            message = message + '?';
            costToPay.clearPaid();
            if (costToPay.canPay(source, source, source.getControllerId(), game) && player.chooseUse(Outcome.Benefit, message, source, game) && costToPay.pay(source, game, source, source.getControllerId(), false, null)) {
                game.informPlayers(player.getLogName() + " chooses to " + logMessage + " to prevent sacrifice effect");
                return true;
            }
            game.informPlayers(player.getLogName() + " chooses not to " + logMessage + " to prevent sacrifice effect");
            if (source.getStackMomentSourceZCC() == game.getState().getZoneChangeCounter(source.getSourceId()) && game.getState().getZone(source.getSourceId()) == Zone.BATTLEFIELD) {
                sourcePermanent.sacrifice(source, game);
            }
            return true;
        }
        return false;
    }

    @Override
    public SacrificeSourceUnlessPaysEffect copy() {
        return new SacrificeSourceUnlessPaysEffect(this);
    }

    @Override
    public String getText(Mode mode) {
        if (this.staticText != null && !this.staticText.isEmpty()) {
            return this.staticText;
        }
        return "sacrifice {this} unless you " + CardUtil.addCostVerb(this.cost != null ? this.cost.getText() : "{X}");
    }
}

