/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.PhaseStep;
import mage.game.Game;
import mage.game.turn.TurnMod;
import mage.players.Player;

public class SkipNextPlayerUntapStepEffect
extends OneShotEffect {
    public SkipNextPlayerUntapStepEffect() {
        this("");
    }

    public SkipNextPlayerUntapStepEffect(String text) {
        super(Outcome.Detriment);
        this.staticText = text.isEmpty() ? "You skip your next untap step" : text + " skips their next untap step";
    }

    protected SkipNextPlayerUntapStepEffect(SkipNextPlayerUntapStepEffect effect) {
        super(effect);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player player = !this.getTargetPointer().getTargets(game, source).isEmpty() ? game.getPlayer(this.getTargetPointer().getFirst(game, source)) : game.getPlayer(source.getControllerId());
        if (player != null) {
            game.getState().getTurnMods().add(new TurnMod(player.getId()).withSkipStep(PhaseStep.UNTAP));
            return true;
        }
        return false;
    }

    @Override
    public SkipNextPlayerUntapStepEffect copy() {
        return new SkipNextPlayerUntapStepEffect(this);
    }
}

