/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;

public class SuspectTargetEffect
extends OneShotEffect {
    public SuspectTargetEffect() {
        super(Outcome.Benefit);
    }

    private SuspectTargetEffect(SuspectTargetEffect effect) {
        super(effect);
    }

    @Override
    public SuspectTargetEffect copy() {
        return new SuspectTargetEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        for (UUID targetId : this.getTargetPointer().getTargets(game, source)) {
            Permanent permanent = game.getPermanent(targetId);
            if (permanent == null) continue;
            permanent.setSuspected(true, game, source);
        }
        return true;
    }

    @Override
    public String getText(Mode mode) {
        if (this.staticText != null && !this.staticText.isEmpty()) {
            return this.staticText;
        }
        return "suspect " + this.getTargetPointer().describeTargets(mode.getTargets(), "that creature");
    }
}

