/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import mage.abilities.Ability;
import mage.abilities.costs.mana.ManaCost;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.mana.ActivatedManaAbilityImpl;
import mage.constants.AbilityType;
import mage.constants.Outcome;
import mage.filter.StaticFilters;
import mage.filter.common.FilterLandPermanent;
import mage.filter.predicate.permanent.PermanentReferenceInCollectionPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.TargetPermanent;

public class TargetPlayerActivatesAllManaAbilitiesEffect
extends OneShotEffect {
    public TargetPlayerActivatesAllManaAbilitiesEffect() {
        super(Outcome.Detriment);
    }

    protected TargetPlayerActivatesAllManaAbilitiesEffect(TargetPlayerActivatesAllManaAbilitiesEffect effect) {
        super(effect);
    }

    @Override
    public TargetPlayerActivatesAllManaAbilitiesEffect copy() {
        return new TargetPlayerActivatesAllManaAbilitiesEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player targetPlayer = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (targetPlayer == null) {
            return false;
        }
        ArrayList<Permanent> ignorePermanents = new ArrayList<Permanent>();
        HashMap manaAbilitiesMap = new HashMap();
        TargetPermanent target = null;
        block0: while (targetPlayer.canRespond()) {
            Permanent permanent2;
            targetPlayer.setPayManaMode(true);
            manaAbilitiesMap.clear();
            for (Permanent permanent2 : game.getBattlefield().getAllActivePermanents(StaticFilters.FILTER_LAND, targetPlayer.getId(), game)) {
                if (ignorePermanents.contains(permanent2)) continue;
                ArrayList<ActivatedManaAbilityImpl> manaAbilities = new ArrayList<ActivatedManaAbilityImpl>();
                block2: for (Ability ability : permanent2.getAbilities()) {
                    ActivatedManaAbilityImpl manaAbility;
                    if (!AbilityType.ACTIVATED_MANA.equals((Object)ability.getAbilityType()) || !(manaAbility = (ActivatedManaAbilityImpl)ability).canActivate(targetPlayer.getId(), game).canActivate()) continue;
                    for (ManaCost manaCost : manaAbility.getManaCosts()) {
                        if (targetPlayer.getManaPool().getMana().includesMana(manaCost.getMana())) continue;
                        continue block2;
                    }
                    manaAbilities.add(manaAbility);
                }
                if (manaAbilities.isEmpty()) continue;
                manaAbilitiesMap.put(permanent2, manaAbilities);
            }
            if (manaAbilitiesMap.isEmpty()) break;
            ArrayList<Permanent> permList = new ArrayList<Permanent>(manaAbilitiesMap.keySet());
            if (permList.size() > 1 || target != null) {
                FilterLandPermanent filter2 = new FilterLandPermanent("land you control to tap for mana (remaining: " + permList.size() + ')');
                filter2.add(new PermanentReferenceInCollectionPredicate(permList, game));
                target = new TargetPermanent(1, 1, filter2, true);
                while (!target.isChosen(game) && target.canChoose(targetPlayer.getId(), source, game) && targetPlayer.canRespond()) {
                    targetPlayer.choose(Outcome.Neutral, target, source, game);
                }
                permanent2 = game.getPermanent(target.getFirstTarget());
            } else {
                permanent2 = (Permanent)permList.get(0);
            }
            if (permanent2 == null) continue;
            int i = 0;
            for (ActivatedManaAbilityImpl manaAbility : (List)manaAbilitiesMap.get(permanent2)) {
                if (((List)manaAbilitiesMap.get(permanent2)).size() > ++i && !targetPlayer.chooseUse(Outcome.Neutral, "Activate mana ability \"" + manaAbility.getRule() + "\" of " + permanent2.getLogName() + "? (Choose \"no\" to activate next mana ability)", source, game)) continue;
                boolean originalCanUndo = manaAbility.isUndoPossible();
                manaAbility.setUndoPossible(false);
                if (targetPlayer.activateAbility(manaAbility, game)) {
                    ignorePermanents.add(permanent2);
                }
                manaAbility.setUndoPossible(originalCanUndo);
                continue block0;
            }
        }
        targetPlayer.setPayManaMode(false);
        return true;
    }
}

