/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;

public class TransformTargetEffect
extends OneShotEffect {
    public TransformTargetEffect() {
        super(Outcome.Transform);
    }

    protected TransformTargetEffect(TransformTargetEffect effect) {
        super(effect);
    }

    @Override
    public TransformTargetEffect copy() {
        return new TransformTargetEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        for (UUID targetId : this.getTargetPointer().getTargets(game, source)) {
            Permanent permanent = game.getPermanent(targetId);
            if (permanent == null) continue;
            permanent.transform(source, game);
        }
        return true;
    }

    @Override
    public String getText(Mode mode) {
        if (this.staticText != null && !this.staticText.isEmpty()) {
            return this.staticText;
        }
        return "transform " + this.getTargetPointer().describeTargets(mode.getTargets(), "that creature");
    }
}

