/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import java.util.UUID;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.SpecialAction;
import mage.abilities.effects.Effect;
import mage.constants.PhaseStep;
import mage.game.Game;
import mage.game.events.GameEvent;

class UnlessPaysDelayedEffectTriggeredAbility
extends DelayedTriggeredAbility {
    private UUID specialActionId;
    private final UUID turnPlayer;
    private final PhaseStep step;

    public UnlessPaysDelayedEffectTriggeredAbility(UUID turnPlayer, PhaseStep step, Effect effect) {
        super(effect);
        this.turnPlayer = turnPlayer;
        this.step = step;
    }

    public void setSpecialActionId(UUID specialActionId) {
        this.specialActionId = specialActionId;
    }

    protected UnlessPaysDelayedEffectTriggeredAbility(UnlessPaysDelayedEffectTriggeredAbility ability) {
        super(ability);
        this.turnPlayer = ability.turnPlayer;
        this.step = ability.step;
        this.specialActionId = ability.specialActionId;
    }

    @Override
    public UnlessPaysDelayedEffectTriggeredAbility copy() {
        return new UnlessPaysDelayedEffectTriggeredAbility(this);
    }

    @Override
    public boolean checkEventType(GameEvent event, Game game) {
        switch (this.step) {
            case UPKEEP: {
                return event.getType() == GameEvent.EventType.UPKEEP_STEP_PRE;
            }
            case DRAW: {
                return event.getType() == GameEvent.EventType.DRAW_STEP_PRE;
            }
        }
        return false;
    }

    @Override
    public boolean checkTrigger(GameEvent event, Game game) {
        if (event.getPlayerId().equals(this.turnPlayer)) {
            for (SpecialAction action : game.getState().getSpecialActions()) {
                if (!action.getId().equals(this.specialActionId)) continue;
                game.getState().getSpecialActions().remove(action);
                break;
            }
            return true;
        }
        return false;
    }
}

