/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.filter.common.FilterLandPermanent;
import mage.filter.predicate.permanent.TappedPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.TargetPermanent;
import mage.util.CardUtil;

public class UntapLandsEffect
extends OneShotEffect {
    private static final FilterLandPermanent filterAll = new FilterLandPermanent("land(s) to untap");
    private static final FilterLandPermanent filterControlled = new FilterLandPermanent("land(s) to untap");
    private final FilterLandPermanent filter;
    private final int amount;
    private final boolean upTo;

    public UntapLandsEffect(int amount) {
        this(amount, true);
    }

    public UntapLandsEffect(int amount, boolean upTo) {
        this(amount, upTo, false);
    }

    public UntapLandsEffect(int amount, boolean upTo, boolean onlyControlled) {
        super(Outcome.Untap);
        this.amount = amount;
        this.upTo = upTo;
        this.filter = onlyControlled ? filterControlled : filterAll;
        this.staticText = "untap " + (upTo ? "up to " : "") + CardUtil.numberToText(amount, this.staticText) + " lands" + (onlyControlled ? " you control" : "");
    }

    protected UntapLandsEffect(UntapLandsEffect effect) {
        super(effect);
        this.amount = effect.amount;
        this.upTo = effect.upTo;
        this.filter = effect.filter;
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            int tappedLands = this.upTo ? game.getBattlefield().getAllActivePermanents(this.filter, controller.getId(), game).size() : game.getBattlefield().getActivePermanents(this.filter, source.getControllerId(), source, game).size();
            TargetPermanent target = new TargetPermanent(this.upTo ? 0 : Math.min(tappedLands, this.amount), this.amount, this.filter, true);
            if (target.canChoose(source.getControllerId(), source, game)) {
                if (tappedLands <= this.amount && this.upTo && controller.chooseUse(this.outcome, "Include your tapped lands to untap?", source, game)) {
                    for (Permanent land : game.getBattlefield().getAllActivePermanents(this.filter, controller.getId(), game)) {
                        target.addTarget(land.getId(), source, game);
                    }
                }
                if (target.choose(Outcome.Untap, source.getControllerId(), source.getSourceId(), source, game)) {
                    for (UUID targetId : target.getTargets()) {
                        Permanent p = game.getPermanent(targetId);
                        if (p == null) continue;
                        p.untap(game);
                    }
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public UntapLandsEffect copy() {
        return new UntapLandsEffect(this);
    }

    static {
        filterAll.add(TappedPredicate.TAPPED);
        filterControlled.add(TappedPredicate.TAPPED);
        filterControlled.add(TargetController.YOU.getControllerPredicate());
    }
}

