/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.choices.TwoChoiceVote;
import mage.constants.AbilityWord;
import mage.constants.Outcome;
import mage.game.Game;

public class WillOfThePlaneswalkersEffect
extends OneShotEffect {
    public WillOfThePlaneswalkersEffect() {
        super(Outcome.Benefit);
        this.staticText = AbilityWord.WILL_OF_THE_PLANESWALKERS.formatWord() + "Starting with you, each player votes for planeswalk or chaos. If planeswalk gets more votes, planeswalk. If chaos gets more votes or the vote is tied, chaos ensues";
        this.concatBy("<br>");
    }

    private WillOfThePlaneswalkersEffect(WillOfThePlaneswalkersEffect effect) {
        super(effect);
    }

    @Override
    public WillOfThePlaneswalkersEffect copy() {
        return new WillOfThePlaneswalkersEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        TwoChoiceVote vote = new TwoChoiceVote("Planeswalk", "Chaos", Outcome.Benefit);
        vote.doVotes(source, game);
        int planeswalkCount = vote.getVoteCount(true);
        int chaosCount = vote.getVoteCount(false);
        if (planeswalkCount > chaosCount) {
            // empty if block
        }
        return true;
    }
}

