/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.combat;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;

public class CanAttackAsThoughItDidntHaveDefenderAllEffect
extends AsThoughEffectImpl {
    private final FilterPermanent filter;

    public CanAttackAsThoughItDidntHaveDefenderAllEffect(Duration duration, FilterPermanent filter) {
        super(AsThoughEffectType.ATTACK, duration, Outcome.Benefit);
        this.filter = filter;
        this.staticText = this.getText();
    }

    private CanAttackAsThoughItDidntHaveDefenderAllEffect(CanAttackAsThoughItDidntHaveDefenderAllEffect effect) {
        super(effect);
        this.filter = effect.filter.copy();
    }

    @Override
    public CanAttackAsThoughItDidntHaveDefenderAllEffect copy() {
        return new CanAttackAsThoughItDidntHaveDefenderAllEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        return true;
    }

    @Override
    public boolean applies(UUID objectId, Ability source, UUID affectedControllerId, Game game) {
        Permanent permanent = game.getPermanent(objectId);
        return this.filter.match(permanent, source.getControllerId(), source, game);
    }

    private String getText() {
        StringBuilder sb = new StringBuilder(this.filter.getMessage());
        sb.append(" can attack ");
        if (!this.duration.toString().isEmpty()) {
            if (Duration.EndOfTurn == this.duration) {
                sb.append("this turn");
            } else {
                sb.append(this.duration.toString());
            }
            sb.append(' ');
        }
        sb.append("as though they didn't have defender");
        return sb.toString();
    }
}

