/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.combat;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.game.permanent.Permanent;

public class CanBlockAdditionalCreatureTargetEffect
extends ContinuousEffectImpl {
    protected int amount;

    public CanBlockAdditionalCreatureTargetEffect() {
        this(Duration.EndOfTurn, 1);
    }

    public CanBlockAdditionalCreatureTargetEffect(Duration duration, int amount) {
        super(duration, Outcome.Benefit);
        this.amount = amount;
    }

    protected CanBlockAdditionalCreatureTargetEffect(CanBlockAdditionalCreatureTargetEffect effect) {
        super(effect);
        this.amount = effect.amount;
    }

    @Override
    public CanBlockAdditionalCreatureTargetEffect copy() {
        return new CanBlockAdditionalCreatureTargetEffect(this);
    }

    @Override
    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        Permanent target = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (target == null) {
            return false;
        }
        if (this.amount > 0) {
            if (target.getMaxBlocks() > 0) {
                target.setMaxBlocks(target.getMaxBlocks() + this.amount);
            }
        } else {
            target.setMaxBlocks(0);
        }
        return true;
    }

    @Override
    public boolean apply(Game game, Ability source) {
        return false;
    }

    @Override
    public boolean hasLayer(Layer layer) {
        return layer == Layer.RulesEffects;
    }
}

