/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.combat;

import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.mana.ManaCosts;
import mage.abilities.effects.PayCostToAttackBlockEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;

public class CantAttackBlockUnlessPaysSourceEffect
extends PayCostToAttackBlockEffectImpl {
    public CantAttackBlockUnlessPaysSourceEffect(Cost cost, PayCostToAttackBlockEffectImpl.RestrictType restrictType) {
        super(Duration.WhileOnBattlefield, Outcome.Detriment, restrictType, cost);
        this.staticText = "{this} can't " + restrictType.toString() + " unless you " + (cost == null ? "" : cost.getText()) + (restrictType == PayCostToAttackBlockEffectImpl.RestrictType.ATTACK ? ". <i>(This cost is paid as attackers are declared.)</i>" : "");
    }

    public CantAttackBlockUnlessPaysSourceEffect(ManaCosts manaCosts, PayCostToAttackBlockEffectImpl.RestrictType restrictType) {
        super(Duration.WhileOnBattlefield, Outcome.Detriment, PayCostToAttackBlockEffectImpl.RestrictType.ATTACK_AND_BLOCK, manaCosts);
        this.staticText = "{this} can't " + restrictType.toString() + " unless you pay " + (manaCosts == null ? "" : manaCosts.getText());
    }

    protected CantAttackBlockUnlessPaysSourceEffect(CantAttackBlockUnlessPaysSourceEffect effect) {
        super(effect);
    }

    @Override
    public boolean applies(GameEvent event, Ability source, Game game) {
        if (this.restrictType != PayCostToAttackBlockEffectImpl.RestrictType.BLOCK && event.getType() == GameEvent.EventType.DECLARE_ATTACKER) {
            return event.getSourceId().equals(source.getSourceId());
        }
        if (this.restrictType != PayCostToAttackBlockEffectImpl.RestrictType.ATTACK && event.getType() == GameEvent.EventType.DECLARE_BLOCKER) {
            return event.getSourceId().equals(source.getSourceId());
        }
        return false;
    }

    @Override
    public CantAttackBlockUnlessPaysSourceEffect copy() {
        return new CantAttackBlockUnlessPaysSourceEffect(this);
    }
}

