/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.combat;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.RestrictionEffect;
import mage.constants.Duration;
import mage.filter.FilterPermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

public class CantAttackUnlessDefenderControllsPermanent
extends RestrictionEffect {
    private final FilterPermanent filter;

    public CantAttackUnlessDefenderControllsPermanent(FilterPermanent filter) {
        super(Duration.WhileOnBattlefield);
        this.filter = filter;
        this.staticText = "{this} can't attack unless defending player controls " + filter.getMessage();
    }

    protected CantAttackUnlessDefenderControllsPermanent(CantAttackUnlessDefenderControllsPermanent effect) {
        super(effect);
        this.filter = effect.filter;
    }

    @Override
    public boolean applies(Permanent permanent, Ability source, Game game) {
        return permanent.getId().equals(source.getSourceId());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean canAttack(Permanent attacker, UUID defenderId, Ability source, Game game, boolean canUseChooseDialogs) {
        UUID defendingPlayerId;
        if (defenderId == null) {
            return true;
        }
        Player player = game.getPlayer(defenderId);
        if (player == null) {
            Permanent permanent = game.getPermanent(defenderId);
            if (permanent == null) return false;
            defendingPlayerId = permanent.getControllerId();
        } else {
            defendingPlayerId = defenderId;
        }
        if (defendingPlayerId == null) return true;
        if (game.getBattlefield().countAll(this.filter, defendingPlayerId, game) == 0) return false;
        return true;
    }

    @Override
    public CantAttackUnlessDefenderControllsPermanent copy() {
        return new CantAttackUnlessDefenderControllsPermanent(this);
    }
}

