/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.combat;

import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.effects.PayCostToAttackBlockEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.StaticFilters;
import mage.filter.common.FilterCreaturePermanent;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

public class CantAttackYouUnlessPayAllEffect
extends PayCostToAttackBlockEffectImpl {
    private final FilterCreaturePermanent filterCreaturePermanent;
    private final Scope scope;

    public CantAttackYouUnlessPayAllEffect(Duration duration, Cost cost) {
        this(duration, cost, Scope.YOU_ONLY);
    }

    public CantAttackYouUnlessPayAllEffect(Duration duration, Cost cost, Scope scope) {
        this(duration, cost, scope, StaticFilters.FILTER_PERMANENT_CREATURES);
    }

    public CantAttackYouUnlessPayAllEffect(Duration duration, Cost cost, Scope scope, FilterCreaturePermanent filter) {
        super(duration, Outcome.Detriment, PayCostToAttackBlockEffectImpl.RestrictType.ATTACK, cost);
        this.scope = scope;
        this.filterCreaturePermanent = filter;
        String durationText = duration.toString();
        this.staticText = (durationText.isEmpty() ? "" : durationText + ", ") + this.filterCreaturePermanent.getMessage() + " can't attack " + scope.firstText + " unless their controller pays " + cost.getText() + " for each " + scope.secondText;
    }

    protected CantAttackYouUnlessPayAllEffect(CantAttackYouUnlessPayAllEffect effect) {
        super(effect);
        this.scope = effect.scope;
        this.filterCreaturePermanent = effect.filterCreaturePermanent;
    }

    @Override
    public boolean applies(GameEvent event, Ability source, Game game) {
        Permanent permanent;
        if (this.filterCreaturePermanent != null && !this.filterCreaturePermanent.match(permanent = game.getPermanent(event.getSourceId()), source.getControllerId(), source, game)) {
            return false;
        }
        if (this.scope.attackingYou && source.isControlledBy(event.getTargetId())) {
            return true;
        }
        return this.scope.attackingControlledPlaneswalkers && (permanent = game.getPermanent(event.getTargetId())) != null && permanent.isPlaneswalker(game) && permanent.isControlledBy(source.getControllerId());
    }

    @Override
    public CantAttackYouUnlessPayAllEffect copy() {
        return new CantAttackYouUnlessPayAllEffect(this);
    }

    public static enum Scope {
        YOU_AND_CONTROLLED_PLANESWALKERS(true, true, "you or planeswalkers you control", "of those creatures"),
        YOU_ONLY(true, false, "you", "creature they control that's attacking you"),
        CONTROLLED_PLANESWALKERS_ONLY(false, true, "planeswalkers you control", "creature they control that's attacking a planeswalker you control");

        final boolean attackingYou;
        final boolean attackingControlledPlaneswalkers;
        final String firstText;
        final String secondText;

        private Scope(boolean attackingYou, boolean attackingControlledPlaneswalkers, String firstText, String secondText) {
            this.attackingYou = attackingYou;
            this.attackingControlledPlaneswalkers = attackingControlledPlaneswalkers;
            this.firstText = firstText;
            this.secondText = secondText;
        }
    }
}

