/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.combat;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.RequirementEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.permanent.Permanent;

public class MustBeBlockedByAtLeastOneSourceEffect
extends RequirementEffect {
    private int minNumberOfBlockers;

    public MustBeBlockedByAtLeastOneSourceEffect(Duration duration) {
        this(duration, 1);
    }

    public MustBeBlockedByAtLeastOneSourceEffect(Duration duration, int minNumberOfBlockers) {
        super(duration);
        this.minNumberOfBlockers = minNumberOfBlockers;
        this.staticText = "{this} must be blocked " + (duration == Duration.EndOfTurn ? "this turn " : "") + "if able";
    }

    protected MustBeBlockedByAtLeastOneSourceEffect(MustBeBlockedByAtLeastOneSourceEffect effect) {
        super(effect);
        this.minNumberOfBlockers = effect.minNumberOfBlockers;
    }

    @Override
    public boolean applies(Permanent permanent, Ability source, Game game) {
        return permanent.canBlock(source.getSourceId(), game);
    }

    @Override
    public boolean mustAttack(Game game) {
        return false;
    }

    @Override
    public boolean mustBlock(Game game) {
        return false;
    }

    @Override
    public UUID mustBlockAttackerIfElseUnblocked(Ability source, Game game) {
        return source.getSourceId();
    }

    @Override
    public int getMinNumberOfBlockers() {
        return this.minNumberOfBlockers;
    }

    @Override
    public MustBeBlockedByAtLeastOneSourceEffect copy() {
        return new MustBeBlockedByAtLeastOneSourceEffect(this);
    }
}

