/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.combat;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.RequirementEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.permanent.Permanent;

public class MustBeBlockedByAtLeastOneTargetEffect
extends RequirementEffect {
    public MustBeBlockedByAtLeastOneTargetEffect() {
        this(Duration.EndOfTurn);
    }

    public MustBeBlockedByAtLeastOneTargetEffect(Duration duration) {
        super(duration);
        this.staticText = "target creature must be blocked this turn if able";
    }

    protected MustBeBlockedByAtLeastOneTargetEffect(MustBeBlockedByAtLeastOneTargetEffect effect) {
        super(effect);
    }

    @Override
    public boolean applies(Permanent permanent, Ability source, Game game) {
        return permanent.canBlock(this.getTargetPointer().getFirst(game, source), game);
    }

    @Override
    public boolean mustAttack(Game game) {
        return false;
    }

    @Override
    public boolean mustBlock(Game game) {
        return false;
    }

    @Override
    public UUID mustBlockAttackerIfElseUnblocked(Ability source, Game game) {
        return this.getTargetPointer().getFirst(game, source);
    }

    @Override
    public MustBeBlockedByAtLeastOneTargetEffect copy() {
        return new MustBeBlockedByAtLeastOneTargetEffect(this);
    }
}

