/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.combat;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.RequirementEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.watchers.common.BlockedAttackerWatcher;

public class MustBeBlockedByTargetSourceEffect
extends RequirementEffect {
    public MustBeBlockedByTargetSourceEffect() {
        this(Duration.EndOfTurn);
    }

    public MustBeBlockedByTargetSourceEffect(Duration duration) {
        super(duration);
        this.staticText = "target creature blocks {this} this turn if able";
    }

    protected MustBeBlockedByTargetSourceEffect(MustBeBlockedByTargetSourceEffect effect) {
        super(effect);
    }

    @Override
    public boolean applies(Permanent permanent, Ability source, Game game) {
        Permanent blocker;
        if (permanent.getId().equals(this.getTargetPointer().getFirst(game, source)) && (blocker = game.getPermanent(this.getTargetPointer().getFirst(game, source))) != null && blocker.canBlock(source.getSourceId(), game)) {
            Permanent attacker = source.getSourcePermanentIfItStillExists(game);
            if (attacker != null) {
                BlockedAttackerWatcher blockedAttackerWatcher = game.getState().getWatcher(BlockedAttackerWatcher.class);
                return blockedAttackerWatcher == null || !blockedAttackerWatcher.creatureHasBlockedAttacker(attacker, blocker, game);
            }
            this.discard();
        }
        return false;
    }

    @Override
    public boolean mustAttack(Game game) {
        return false;
    }

    @Override
    public boolean mustBlock(Game game) {
        return true;
    }

    @Override
    public UUID mustBlockAttacker(Ability source, Game game) {
        return source.getSourceId();
    }

    @Override
    public MustBeBlockedByTargetSourceEffect copy() {
        return new MustBeBlockedByTargetSourceEffect(this);
    }
}

