/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.combat;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.RestrictionEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.permanent.Permanent;

public class TargetPlayerCantAttackYouEffect
extends RestrictionEffect {
    public TargetPlayerCantAttackYouEffect(Duration duration) {
        super(duration);
    }

    protected TargetPlayerCantAttackYouEffect(TargetPlayerCantAttackYouEffect effect) {
        super(effect);
    }

    @Override
    public TargetPlayerCantAttackYouEffect copy() {
        return new TargetPlayerCantAttackYouEffect(this);
    }

    @Override
    public boolean applies(Permanent permanent, Ability source, Game game) {
        return this.getTargetPointer().getTargets(game, source).contains(permanent.getControllerId());
    }

    @Override
    public boolean canAttack(Permanent attacker, UUID defenderId, Ability source, Game game, boolean canUseChooseDialogs) {
        if (defenderId == null) {
            return true;
        }
        if (game.getPermanent(defenderId) != null) {
            return true;
        }
        return !defenderId.equals(source.getControllerId());
    }
}

