/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.continuous;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.AttachmentType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

public class AddCardSubtypeAttachedEffect
extends ContinuousEffectImpl {
    private final SubType addedSubtype;

    public AddCardSubtypeAttachedEffect(SubType addedSubtype, AttachmentType attachmentType) {
        super(Duration.WhileOnBattlefield, Layer.TypeChangingEffects_4, SubLayer.NA, Outcome.Benefit);
        this.addedSubtype = addedSubtype;
        this.staticText = attachmentType.verb() + " creature becomes " + CardUtil.addArticle(addedSubtype.getDescription()) + " in addition to its other types";
    }

    protected AddCardSubtypeAttachedEffect(AddCardSubtypeAttachedEffect effect) {
        super(effect);
        this.addedSubtype = effect.addedSubtype;
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Permanent target;
        Permanent equipment = game.getPermanent(source.getSourceId());
        if (equipment != null && equipment.getAttachedTo() != null && (target = game.getPermanent(equipment.getAttachedTo())) != null) {
            target.addSubType(game, this.addedSubtype);
        }
        return true;
    }

    @Override
    public AddCardSubtypeAttachedEffect copy() {
        return new AddCardSubtypeAttachedEffect(this);
    }
}

