/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.continuous;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.CardType;
import mage.constants.DependencyType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.game.permanent.Permanent;

public class AddCardTypeTargetEffect
extends ContinuousEffectImpl {
    private final List<CardType> addedCardTypes = new ArrayList<CardType>();

    public AddCardTypeTargetEffect(Duration duration, CardType ... addedCardType) {
        super(duration, Layer.TypeChangingEffects_4, SubLayer.NA, Outcome.Benefit);
        if (addedCardType.length == 0) {
            throw new IllegalArgumentException("AddCardTypeTargetEffect should be called with at least one card type.");
        }
        for (CardType cardType : addedCardType) {
            this.addedCardTypes.add(cardType);
            if (cardType == CardType.ENCHANTMENT) {
                this.dependencyTypes.add(DependencyType.EnchantmentAddingRemoving);
                continue;
            }
            if (cardType == CardType.ARTIFACT) {
                this.dependencyTypes.add(DependencyType.ArtifactAddingRemoving);
                continue;
            }
            if (cardType != CardType.LAND) continue;
            this.dependencyTypes.add(DependencyType.BecomeNonbasicLand);
        }
    }

    protected AddCardTypeTargetEffect(AddCardTypeTargetEffect effect) {
        super(effect);
        this.addedCardTypes.addAll(effect.addedCardTypes);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        boolean result = false;
        for (UUID targetId : this.getTargetPointer().getTargets(game, source)) {
            Permanent target = game.getPermanent(targetId);
            if (target == null) continue;
            for (CardType cardType : this.addedCardTypes) {
                target.addCardType(game, cardType);
            }
            result = true;
        }
        if (!result && this.getDuration() == Duration.Custom) {
            this.discard();
        }
        return result;
    }

    @Override
    public AddCardTypeTargetEffect copy() {
        return new AddCardTypeTargetEffect(this);
    }

    @Override
    public String getText(Mode mode) {
        if (this.staticText != null && !this.staticText.isEmpty()) {
            return this.staticText;
        }
        StringBuilder sb = new StringBuilder(this.getTargetPointer().describeTargets(mode.getTargets(), "it"));
        sb.append(this.getTargetPointer().isPlural(mode.getTargets()) ? " become " : " becomes ");
        boolean article = false;
        for (CardType cardType : this.addedCardTypes) {
            if (!article) {
                if (cardType.toString().startsWith("A") || cardType.toString().startsWith("E")) {
                    sb.append("an ");
                } else {
                    sb.append("a ");
                }
                article = true;
            }
            sb.append(cardType.toString().toLowerCase(Locale.ENGLISH)).append(" ");
        }
        sb.append("in addition to its other types");
        if (this.getDuration() == Duration.EndOfTurn) {
            sb.append(" until end of turn");
        }
        return sb.toString();
    }
}

