/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.continuous;

import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BecomesColorTargetEffect;
import mage.choices.ChoiceColor;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;

public class BecomesColorOrColorsTargetEffect
extends OneShotEffect {
    Duration duration;

    public BecomesColorOrColorsTargetEffect(Duration duration) {
        super(Outcome.Neutral);
        this.duration = duration;
    }

    protected BecomesColorOrColorsTargetEffect(BecomesColorOrColorsTargetEffect effect) {
        super(effect);
        this.duration = effect.duration;
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent target = game.getPermanent(source.getFirstTarget());
        StringBuilder sb = new StringBuilder();
        if (controller != null && target != null) {
            for (int i = 0; i < 5 && (i <= 0 || controller.chooseUse(Outcome.Neutral, "Choose another color?", source, game)); ++i) {
                ChoiceColor choiceColor = new ChoiceColor();
                if (!controller.choose(Outcome.Benefit, choiceColor, game)) {
                    return false;
                }
                if (!game.isSimulation()) {
                    game.informPlayers(target.getName() + ": " + controller.getLogName() + " has chosen " + choiceColor.getChoice());
                }
                if (choiceColor.getColor().isBlack()) {
                    sb.append('B');
                    continue;
                }
                if (choiceColor.getColor().isBlue()) {
                    sb.append('U');
                    continue;
                }
                if (choiceColor.getColor().isRed()) {
                    sb.append('R');
                    continue;
                }
                if (choiceColor.getColor().isGreen()) {
                    sb.append('G');
                    continue;
                }
                if (!choiceColor.getColor().isWhite()) continue;
                sb.append('W');
            }
            String colors = new String(sb);
            ObjectColor chosenColors = new ObjectColor(colors);
            BecomesColorTargetEffect effect = new BecomesColorTargetEffect(chosenColors, this.duration);
            effect.setTargetPointer(new FixedTarget(source.getFirstTarget(), game));
            game.addEffect(effect, source);
            return true;
        }
        return false;
    }

    @Override
    public BecomesColorOrColorsTargetEffect copy() {
        return new BecomesColorOrColorsTargetEffect(this);
    }

    @Override
    public String getText(Mode mode) {
        if (this.staticText != null && !this.staticText.isEmpty()) {
            return this.staticText;
        }
        return this.getTargetPointer().describeTargets(mode.getTargets(), "it") + (this.getTargetPointer().isPlural(mode.getTargets()) ? " become " : " becomes ") + "the color or colors of your choice" + (this.duration.toString().isEmpty() ? "" : ' ' + this.duration.toString());
    }
}

