/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.continuous;

import java.util.UUID;
import mage.MageObject;
import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.choices.ChoiceColor;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.stack.Spell;
import mage.players.Player;

public class BecomesColorTargetEffect
extends ContinuousEffectImpl {
    private ObjectColor setColor;
    private final boolean retainColor;

    public BecomesColorTargetEffect(Duration duration) {
        this(null, duration);
    }

    public BecomesColorTargetEffect(ObjectColor setColor, Duration duration) {
        this(setColor, false, duration);
    }

    public BecomesColorTargetEffect(ObjectColor setColor, boolean retainColor, Duration duration) {
        super(duration, Layer.ColorChangingEffects_5, SubLayer.NA, Outcome.Benefit);
        this.setColor = setColor;
        this.retainColor = retainColor;
    }

    protected BecomesColorTargetEffect(BecomesColorTargetEffect effect) {
        super(effect);
        this.setColor = effect.setColor;
        this.retainColor = effect.retainColor;
    }

    @Override
    public void init(Ability source, Game game) {
        super.init(source, game);
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            this.discard();
            return;
        }
        if (this.setColor == null) {
            ChoiceColor choice = new ChoiceColor();
            if (!controller.choose(Outcome.PutManaInPool, choice, game)) {
                this.discard();
                return;
            }
            this.setColor = choice.getColor();
            if (!game.isSimulation()) {
                game.informPlayers(controller.getLogName() + " has chosen the color: " + this.setColor.toString());
            }
        }
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        if (this.setColor != null) {
            boolean objectFound = false;
            for (UUID targetId : this.getTargetPointer().getTargets(game, source)) {
                MageObject targetObject = game.getObject(targetId);
                if (targetObject == null) continue;
                if (targetObject instanceof Spell || targetObject instanceof Permanent) {
                    objectFound = true;
                    if (this.retainColor) {
                        targetObject.getColor(game).addColor(this.setColor);
                        continue;
                    }
                    targetObject.getColor(game).setColor(this.setColor);
                    continue;
                }
                objectFound = false;
            }
            if (!objectFound && this.getDuration() == Duration.Custom) {
                this.discard();
            }
            return true;
        }
        throw new UnsupportedOperationException("No color set");
    }

    @Override
    public BecomesColorTargetEffect copy() {
        return new BecomesColorTargetEffect(this);
    }

    @Override
    public String getText(Mode mode) {
        if (this.staticText != null && !this.staticText.isEmpty()) {
            return this.staticText;
        }
        StringBuilder sb = new StringBuilder(this.getTargetPointer().describeTargets(mode.getTargets(), "it"));
        sb.append(this.getTargetPointer().isPlural(mode.getTargets()) ? " become " : " becomes ");
        if (this.setColor == null) {
            sb.append("the color of your choice");
        } else {
            sb.append(this.setColor.getDescription());
        }
        if (this.retainColor) {
            sb.append(" in addition to its other colors");
        }
        if (!this.duration.toString().isEmpty()) {
            sb.append(' ').append(this.duration.toString());
        }
        return sb.toString();
    }
}

