/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.continuous;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.CardType;
import mage.constants.DependencyType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;

public class BecomesCreatureIfVehicleEffect
extends ContinuousEffectImpl {
    private CardType addedType = CardType.CREATURE;

    public BecomesCreatureIfVehicleEffect() {
        super(Duration.WhileOnBattlefield, Layer.TypeChangingEffects_4, SubLayer.NA, Outcome.Benefit);
        this.staticText = "As long as enchanted permanent is a Vehicle, it's a creature in addition to its other types";
        this.dependencyTypes.add(DependencyType.BecomeCreature);
    }

    protected BecomesCreatureIfVehicleEffect(BecomesCreatureIfVehicleEffect effect) {
        super(effect);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Permanent enchanted;
        Permanent aura = game.getPermanent(source.getSourceId());
        if (aura != null && aura.getAttachedTo() != null && (enchanted = game.getPermanent(aura.getAttachedTo())) != null && enchanted.hasSubtype(SubType.VEHICLE, game)) {
            enchanted.addCardType(game, this.addedType);
        }
        return true;
    }

    @Override
    public BecomesCreatureIfVehicleEffect copy() {
        return new BecomesCreatureIfVehicleEffect(this);
    }
}

