/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.continuous;

import java.util.Iterator;
import java.util.Locale;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.StaticValue;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.SubLayer;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

public class BoostAllEffect
extends ContinuousEffectImpl {
    protected DynamicValue power;
    protected DynamicValue toughness;
    protected boolean excludeSource;
    protected FilterPermanent filter;

    public BoostAllEffect(int power, int toughness, Duration duration) {
        this(power, toughness, duration, false);
    }

    public BoostAllEffect(DynamicValue power, DynamicValue toughness, Duration duration) {
        this(power, toughness, duration, StaticFilters.FILTER_PERMANENT_ALL_CREATURES, false);
    }

    public BoostAllEffect(int power, int toughness, Duration duration, boolean excludeSource) {
        this(power, toughness, duration, StaticFilters.FILTER_PERMANENT_ALL_CREATURES, excludeSource);
    }

    public BoostAllEffect(int power, int toughness, Duration duration, FilterCreaturePermanent filter, boolean excludeSource) {
        this((DynamicValue)StaticValue.get(power), (DynamicValue)StaticValue.get(toughness), duration, filter, excludeSource);
    }

    public BoostAllEffect(DynamicValue power, DynamicValue toughness, Duration duration, FilterCreaturePermanent filter, boolean excludeSource) {
        this(power, toughness, duration, filter, excludeSource, null);
    }

    public BoostAllEffect(DynamicValue power, DynamicValue toughness, Duration duration, FilterCreaturePermanent filter, boolean excludeSource, String rule) {
        super(duration, Layer.PTChangingEffects_7, SubLayer.ModifyPT_7c, CardUtil.getBoostOutcome(power, toughness));
        this.power = power;
        this.toughness = toughness;
        this.filter = filter;
        this.excludeSource = excludeSource;
        if (rule == null || rule.isEmpty()) {
            this.setText();
        } else {
            this.staticText = rule;
        }
    }

    public BoostAllEffect(int power, int toughness, Duration duration, FilterControlledCreaturePermanent filter, boolean excludeSource) {
        this((DynamicValue)StaticValue.get(power), (DynamicValue)StaticValue.get(toughness), duration, filter, excludeSource);
    }

    public BoostAllEffect(DynamicValue power, DynamicValue toughness, Duration duration, FilterControlledCreaturePermanent filter, boolean excludeSource) {
        this(power, toughness, duration, filter, excludeSource, null);
    }

    public BoostAllEffect(DynamicValue power, DynamicValue toughness, Duration duration, FilterControlledCreaturePermanent filter, boolean excludeSource, String rule) {
        super(duration, Layer.PTChangingEffects_7, SubLayer.ModifyPT_7c, CardUtil.getBoostOutcome(power, toughness));
        this.power = power;
        this.toughness = toughness;
        this.filter = filter;
        this.excludeSource = excludeSource;
        if (rule == null || rule.isEmpty()) {
            this.setText();
        } else {
            this.staticText = rule;
        }
    }

    protected BoostAllEffect(BoostAllEffect effect) {
        super(effect);
        this.power = effect.power;
        this.toughness = effect.toughness;
        this.filter = effect.filter.copy();
        this.excludeSource = effect.excludeSource;
    }

    @Override
    public BoostAllEffect copy() {
        return new BoostAllEffect(this);
    }

    @Override
    public void init(Ability source, Game game) {
        super.init(source, game);
        this.setRuntimeData(source, game);
        if (this.getAffectedObjectsSet()) {
            for (Permanent perm : game.getBattlefield().getActivePermanents(this.filter, source.getControllerId(), source, game)) {
                if (this.excludeSource && perm.getId().equals(source.getSourceId()) || !this.selectedByRuntimeData(perm, source, game)) continue;
                this.affectedObjectList.add(new MageObjectReference(perm, game));
            }
            this.power = StaticValue.get(this.power.calculate(game, source, this));
            this.toughness = StaticValue.get(this.toughness.calculate(game, source, this));
        }
    }

    @Override
    public boolean apply(Game game, Ability source) {
        if (this.getAffectedObjectsSet()) {
            Iterator it = this.affectedObjectList.iterator();
            while (it.hasNext()) {
                Permanent permanent = ((MageObjectReference)it.next()).getPermanent(game);
                if (permanent != null) {
                    permanent.addPower(this.power.calculate(game, source, this));
                    permanent.addToughness(this.toughness.calculate(game, source, this));
                    continue;
                }
                it.remove();
            }
        } else {
            this.setRuntimeData(source, game);
            for (Permanent perm : game.getBattlefield().getActivePermanents(this.filter, source.getControllerId(), source, game)) {
                if (this.excludeSource && perm.getId().equals(source.getSourceId()) || !this.selectedByRuntimeData(perm, source, game)) continue;
                perm.addPower(this.power.calculate(game, source, this));
                perm.addToughness(this.toughness.calculate(game, source, this));
            }
        }
        return true;
    }

    protected void setRuntimeData(Ability source, Game game) {
    }

    protected boolean selectedByRuntimeData(Permanent permanent, Ability source, Game game) {
        return true;
    }

    protected void setText() {
        StringBuilder sb = new StringBuilder();
        boolean each = this.filter.getMessage().toLowerCase(Locale.ENGLISH).startsWith("each");
        if (this.excludeSource && !each) {
            sb.append("other ");
        }
        sb.append(this.filter.getMessage());
        sb.append(each ? " gets " : " get ");
        sb.append(CardUtil.getBoostText(this.power, this.toughness, this.duration));
        this.staticText = sb.toString();
    }
}

