/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.continuous;

import java.util.Iterator;
import java.util.Locale;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.StaticValue;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

public class BoostControlledEffect
extends ContinuousEffectImpl {
    private DynamicValue power;
    private DynamicValue toughness;
    protected FilterPermanent filter;
    protected boolean excludeSource;

    public BoostControlledEffect(int power, int toughness, Duration duration) {
        this(power, toughness, duration, (FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURES, false);
    }

    public BoostControlledEffect(DynamicValue power, DynamicValue toughness, Duration duration) {
        this(power, toughness, duration, (FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURES, false);
    }

    public BoostControlledEffect(int power, int toughness, Duration duration, boolean excludeSource) {
        this(power, toughness, duration, (FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURES, excludeSource);
    }

    public BoostControlledEffect(int power, int toughness, Duration duration, FilterPermanent filter) {
        this(StaticValue.get(power), StaticValue.get(toughness), duration, filter, false);
    }

    public BoostControlledEffect(int power, int toughness, Duration duration, FilterPermanent filter, boolean excludeSource) {
        this(StaticValue.get(power), StaticValue.get(toughness), duration, filter, excludeSource);
    }

    public BoostControlledEffect(DynamicValue power, DynamicValue toughness, Duration duration, FilterPermanent filter, boolean excludeSource) {
        super(duration, Layer.PTChangingEffects_7, SubLayer.ModifyPT_7c, Outcome.BoostCreature);
        this.power = power;
        this.toughness = toughness;
        this.filter = filter == null ? StaticFilters.FILTER_PERMANENT_CREATURES : filter;
        this.excludeSource = excludeSource;
        this.setText();
    }

    protected BoostControlledEffect(BoostControlledEffect effect) {
        super(effect);
        this.power = effect.power;
        this.toughness = effect.toughness;
        this.filter = effect.filter.copy();
        this.excludeSource = effect.excludeSource;
    }

    @Override
    public BoostControlledEffect copy() {
        return new BoostControlledEffect(this);
    }

    @Override
    public void init(Ability source, Game game) {
        super.init(source, game);
        if (this.getAffectedObjectsSet()) {
            for (Permanent perm : game.getBattlefield().getActivePermanents(this.filter, source.getControllerId(), source, game)) {
                if (!perm.isControlledBy(source.getControllerId()) || this.excludeSource && perm.getId().equals(source.getSourceId())) continue;
                this.affectedObjectList.add(new MageObjectReference(perm, game));
            }
            this.power = StaticValue.get(this.power.calculate(game, source, this));
            this.toughness = StaticValue.get(this.toughness.calculate(game, source, this));
        }
    }

    @Override
    public boolean apply(Game game, Ability source) {
        if (this.getAffectedObjectsSet()) {
            Iterator it = this.affectedObjectList.iterator();
            while (it.hasNext()) {
                Permanent permanent = ((MageObjectReference)it.next()).getPermanent(game);
                if (permanent != null) {
                    permanent.addPower(this.power.calculate(game, source, this));
                    permanent.addToughness(this.toughness.calculate(game, source, this));
                    continue;
                }
                it.remove();
            }
        } else {
            for (Permanent perm : game.getBattlefield().getActivePermanents(this.filter, source.getControllerId(), source, game)) {
                if (!perm.isControlledBy(source.getControllerId()) || this.excludeSource && perm.getId().equals(source.getSourceId())) continue;
                perm.addPower(this.power.calculate(game, source, this));
                perm.addToughness(this.toughness.calculate(game, source, this));
            }
        }
        return true;
    }

    private void setText() {
        StringBuilder sb = new StringBuilder();
        String message = this.filter.getMessage().toLowerCase(Locale.ENGLISH);
        boolean each = message.startsWith("each");
        if (this.excludeSource && !each && !message.startsWith("all")) {
            sb.append("other ");
        }
        sb.append(this.filter.getMessage());
        if (!this.filter.getMessage().endsWith("you control") && !this.filter.getMessage().contains("you control that's")) {
            sb.append(" you control");
        }
        sb.append(each ? " gets " : " get ");
        sb.append(CardUtil.getBoostText(this.power, this.toughness, this.duration));
        this.staticText = sb.toString();
    }
}

