/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.continuous;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.game.permanent.Permanent;

public class BoostPairedEffect
extends ContinuousEffectImpl {
    private int power;
    private int toughness;

    public BoostPairedEffect(int power, int toughness, String rule) {
        super(Duration.WhileOnBattlefield, Layer.PTChangingEffects_7, SubLayer.ModifyPT_7c, Outcome.BoostCreature);
        this.power = power;
        this.toughness = toughness;
        this.staticText = rule;
    }

    protected BoostPairedEffect(BoostPairedEffect effect) {
        super(effect);
        this.power = effect.power;
        this.toughness = effect.toughness;
    }

    @Override
    public BoostPairedEffect copy() {
        return new BoostPairedEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Permanent paired;
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (permanent != null && permanent.getPairedCard() != null && (paired = permanent.getPairedCard().getPermanent(game)) != null) {
            permanent.addPower(this.power);
            permanent.addToughness(this.toughness);
            paired.addPower(this.power);
            paired.addToughness(this.toughness);
            return true;
        }
        return false;
    }
}

